; "Blitz Demo"
; By David Powell - www.loadcode.co.uk
; 7th July 2001
; This code is public domain

; A simple retro style "Demo"
; In the main section of the demo press ESC to quit
; and F11 to toggle FPS display

; This program uses COS and SIN a lot, and would
; probably benefit from using lookup tables...


Graphics 640,480

Dim fontChars(60) ; array of images for the scroller font
Dim lines(50) ; array of images for the water effect

srcW#=128 ; rotozoomer source image width
srcH#=128 ; rotozoomer source image height 
dstW#=160 ; rotozoomer destination image width
dstH#=100 ; rotozoomer destination image height

fSrcRotCX#=64 ; rotozoomer source image rotation centre X
fSrcRotCY#=128 ; rotozoomer source image rotation center Y
fDstRotCX#=0 ; rotozoomer destination image rotation centre X
fDstRotCY#=0 ; rotozoomer destination image rotation centre Y

dirScale=0 ; rotozoomer direction of scaling
scale#=0.5 ; rotozoomer starting scale

dirX=0 ; rotozoomer direction of pan X
dirY=0 ; rotozoomer direction of pan Y

move=0 ; rotozoomer destination movement position

shimmer#=0 ; water effect movement position
textBounce#=0 ; scrolltext vertical movement position
scrollOffset=0 ; scrolltext horizontal movement position
scrollPos=1 ; position in the scrollText string

; The scroll text
scrollText$=String$(" ",20)
scrollText$=scrollText$+"WELCOME TO MY FIRST BLITZ DEMO. FEATURING A REAL-TIME ROTOZOOMER, BOBBING LOGO, MOVING CHECKER BACKGROUND, DUAL SCROLLERS AND A REAL-TIME WATER EFFECT. OH, NEARLY FORGOT THE CYCLING COLOURS AT THE TOP AND BOTTOM."
scrollText$=scrollText$+"   CREDITS: ALL CODE BY DAVID POWELL, MUSIC BY JESTER (MODARCHIVE.COM), ROTOZOOMER IMAGE FROM WALDO'S WALLPAPER (MUNCASTER.COM)"
scrollText$=scrollText$+"    SCROLL WRAPS.....    "

backX=0 ; X position of the background checkers
backY=0 ; Y position of the background checkers

; define flag to tell us what mode we are in
; 0 = running
; 1 = closing down
; 2 = end of program
finished=0

closeOffset=0 ; position of coloured bars when ending demo


; load/play the music and set the volume to maximum
volume#=1.0
music=PlayMusic("media\elysium.mod")
ChannelVolume music, volume#

; load in all the other media
blitzLogo=LoadImage("media\blitz.png")
MaskImage blitzLogo, 30, 30, 100
checkBack=LoadImage("media\checkBack.png")
rotoImage=LoadImage("media\roto.jpg")

; create the images for the water effect
For loop=0 To 49
	lines(loop)=CreateImage(640,1)
Next

fontImage=LoadImage("media\mamor.png")
SetBuffer ImageBuffer(fontImage)

; copy each char into it's own image and store the details in the font array
For vloop=1 To 3
	For hloop=1 To 20
		fontChars(((vloop-1)*20)+(hloop-1))=CreateImage(16, 16)
		GrabImage fontChars(((vloop-1)*20)+(hloop-1)), ((hloop-1)*16), ((vloop-1)*16)
	Next
Next

FreeImage fontImage

; create an image for building each line of text into
scrollImage=CreateImage(640+16, 16)
moveImage=CreateImage(640,16)

; create the cycling coloured lines
lineImage=CreateImage(1530*2,1)
SetBuffer ImageBuffer(lineImage)

red=255
green=0
blue=0

For loop=0 To 254
	blue=blue+1
	Color red, green, blue
	Plot loop, 0
Next

For loop=255 To 509
	red=red-1
	Color red, green, blue
	Plot loop, 0
Next

For loop=510 To 764
	green=green+1
	Color red, green, blue
	Plot loop, 0
Next

For loop=765 To 1019
	blue=blue-1
	Color red, green, blue
	Plot loop, 0
Next

For loop=1020 To 1274
	red=red+1
	Color red, green, blue
	Plot loop, 0
Next

For loop=1275 To 1529
	green=green-1
	Color red, green, blue
	Plot loop, 0
Next

LockBuffer
For loop=0 To 1529
	CopyPixelFast loop, 0, ImageBuffer(lineImage), loop+1530, 0
Next	
UnlockBuffer


; that's all the setup done, now we can start the demo
SetBuffer BackBuffer()

; create a 60Hz timer so that the maximum
; refresh rate doesn't exceed ~60FPS
sync=CreateTimer(60) 

; cycle the coloured lines across the middle of the screen
; for 5 seconds
timer=MilliSecs()
Repeat
	Cls
	DrawBlock lineImage, xPos-1530, 239
	xPos=(xPos+10) Mod 1530
	Flip
Until MilliSecs()-timer>5000

; expand the lines and draw a dark blue between them
Color 30,30,100
xPos=0
For y=1 To 240
	Cls
	DrawBlock lineImage, xPos-1530, 239+y
	DrawBlock lineImage, xPos-1530, 240-y
	xPos=(xPos+10) Mod 1530
	Rect 0,241-y,640,(y*2)-2
	WaitTimer sync
	Flip
Next

; wait for another second, keeping the coloured
; lines moving
ClsColor 30,30,100
timer=MilliSecs()
Repeat
	Cls
	DrawBlock lineImage, xPos-1530, 0
	DrawBlock lineImage, xPos-1530, 479
	xPos=(xPos+10) Mod 1530
	WaitTimer sync
	Flip
Until MilliSecs()-timer>1000

; move the checker background in across the screen
backOff=639
Repeat
	If backOff>=0
		Viewport backOff, 0, 640-backOff, 480
	EndIf
	TileBlock checkBack, backOff, 0
	backOff=backOff-2
	Viewport 0, 0, 640, 480
	DrawBlock lineImage, xPos-1530, 0
	DrawBlock lineImage, xPos-1530, 479
	xPos=(xPos+10) Mod 1530
	WaitTimer sync
	Flip
Until backOff<=-640

; make the entire screen white for 30 milliseconds
; so that it looks like a flash
ClsColor 255,255,255
Cls
Flip
timer=MilliSecs()
Repeat
	VWait
Until MilliSecs()-timer>30

Color 255,255,255

; set up the FPS display
old_time=MilliSecs()
showFPS=False

angle#=0

; start the main demo loop
Repeat

	; update the FPS variable if needed
	frames=frames+1
	If MilliSecs()-old_time=>1000
	    fps=frames
	    frames=0
	    old_time=MilliSecs()
	EndIf
	
	; draw the background checks
	TileBlock checkBack, Sin(backX)*100, Cos(backY)*100
	; move the background checks in a circular motion
	backX=(backX+1) Mod 360
	backY=(backY+1) Mod 360
	
	; update the generic offsets
	; used for the screen position of the rotozoomer
	; and the screen position of the Blitz logo
	xOff=240+(Sin(move*2)*150)
	yOff=180+(Cos(move)*150)
	move=(move+1) Mod 360
	
	; draw the Blitz logo on the screen
	DrawImage blitzLogo, yOff, xOff
	
	; draw the bottom scroller
	DrawImage scrollImage, -scrollOffset, (Cos(textBounce#*10)*10)+390
	textBounce#=(textBounce#+0.5) Mod 360
	scrollOffset=scrollOffset+1 ; scroll the text across the screen
	
	; add a new character to the scroller if it is
	; time to.
	If scrollOffset>=16
		scrollOffset=0
		SetBuffer ImageBuffer(scrollImage)
		GrabImage moveImage, 16, 0
		DrawBlock moveImage, 0, 0
		DrawBlock fontChars(Asc(Mid$(scrollText$, scrollPos, 1))-32), 640, 0
		scrollPos=scrollPos+1
		If scrollPos>Len(scrollText$)-1
			scrollPos=1
		EndIf
		SetBuffer BackBuffer()
	EndIf

	; start of rotozoomer routine
	angle#=angle#+1
	If angle#>359
		angle#=0
	EndIf

	If dirScale=0 
		scale#=scale#+0.005
	ElseIf dirScale=1
		scale#=scale#-0.005
	EndIf

	If scale#>2.0
		dirScale=1
	ElseIf scale#<0.2
		dirScale=0
	EndIf

	If dirX=0
		fDstRotCX#=fDstRotCX#+1
	ElseIf dirX=1
		fDstRotCX#=fDstRotCX#-1
	EndIf

	If fDstRotCX#>128
		dirX=1
	ElseIf fDstRotCX<0
		dirX=0
	EndIf

	If dirY=0
		fDstRotCY#=fDstRotCY#+1
	ElseIf dirY=1
		fDstRotCY#=fDstRotCY#-1
	EndIf

	If fDstRotCY#>256
		dirY=1
	ElseIf fDstRotCY<0
		dirY=0
	EndIf

	duCol# = Sin(-angle#) * (1.0 / scale#)
	dvCol# = Cos(-angle#) * (1.0 / scale#)
	duRow# = dvCol#
	dvRow# =-duCol#

	startingu# = fSrcRotCX# - (fDstRotCX# * dvCol# + fDstRotCY# * duCol#)
	startingv# = fSrcRotCY# - (fDstRotCX# * dvRow# + fDstRotCY# * duRow#)

	LockBuffer BackBuffer()
	LockBuffer ImageBuffer(rotoImage)

	rowu# = startingu#
	rowv# = startingv#
	For y=0 To dstH#-1
	    u# = rowu#
	    v# = rowv#
	    For x=0 To dstW#-1

			CopyPixelFast u And srcW-1, v And srcH-1, ImageBuffer(rotoImage), x+xOff, y+yOff, BackBuffer()

	        u# = u# + duRow#
	        v# = v# + dvRow#
		Next
	    rowu# = rowu# + duCol#
	    rowv# = rowv# + dvCol#
	Next

	UnlockBuffer BackBuffer()
	UnlockBuffer ImageBuffer(rotoImage)
	; end of rotozoomer routine

	; draw a white box around the rotozoomer
	Color 255,255,255
	Line xOff-1,yOff-1,xOff+161, yOff-1
	Line xOff-1,yOff,xOff-1,yOff+101
	Line xOff,yOff+100,xOff+160,yOff+100
	Line xOff+160,yOff,xOff+160,yOff+101

	; draw the top scroller
	DrawImage scrollImage, -scrollOffset, (Sin(textBounce#*10)*10)+50

	; create the ripple effect
	For loop=0 To 49
		GrabImage lines(loop), 0, loop+379
		DrawBlock lines(loop), Cos(shimmer#*19)*10, 478-loop
		shimmer#=(shimmer#+0.4) Mod 360
	Next

	; check the keyboard - ESC Quit - F11 Show/Hide FPS
	If KeyHit(1)
		finished=1
	EndIf
	If KeyHit(87)
		showFPS=Not showFPS
	EndIf
	
	; if ESC was hit then move the coloured bars
	; inward and end the demo
	If finished=1
		DrawBlock lineImage, xPos-1530, closeOffset
		DrawBlock lineImage, xPos-1530, 479-closeOffset
		xPos=(xPos+10) Mod 1530
		closeOffset=closeOffset+1
		Color 0,0,0
		Rect 0,0,640,closeOffset-1
		Rect 0, 479-closeOffset+2, 640, closeOffset-1
		If closeOffset>=241
			finished=2
		EndIf
		ChannelVolume music, volume#
		volume#=volume#-0.004 ; fade the music volume down
	Else
		; normally just keep moving the coloured bars
		; at the top and bottom
		DrawBlock lineImage, xPos-1530, 0
		DrawBlock lineImage, xPos-1530, 479
		xPos=(xPos+10) Mod 1530
	EndIf

	; show the FPS counter if we need to
	If showFPS=True
		Color 255,255,255
		Text 0,0,"FPS: "+fps
	EndIf

	; wait until at least 1/60th of a second has passed
	; since we were last here, so as not to go above
	; ~60FPS on a fast machine
	WaitTimer sync 
	Flip

	; and repeat until we hit ESC
	
Until finished=2

End