; ZX Spectrum Next defines
; EQU format
; V1.0
; Written by David Powell
; This file is released into the public domain


; *** ZX Spectrum Next 8-bit ports, the upper byte is ignored ***

; Sprite palette upload, Write
; Used to upload a 256 colour palette in R3G3B2 format. Pure magenta ($E3, %11100011) is considered transparent.
; The target palette address is auto-incremented after each write.
; Note: The high byte of the port number is ignored so that the OTIR instruction can be used. 
P8W_NX_SPRITE_PALETTE_UPLOAD equ $53

; Sprite attribute upload, Write
; Uploads sprite positions, visibility and effect flags.
; Uploads attributes of the sprite currently selected by the P16RW_NX_SPRITE_STATUS port.
; Attributes are in 4 byte blocks sent in the following order; after sending 4 bytes the address auto-increments to the next sprite.
; This auto-increment is independent of other sprite ports. The 4 bytes are as follows;
; Write Byte 1: Low bits of the X position. Legal X positions are 0-319 if sprites are allowed over the border or 32-287 if not. The MSB is in byte 3.
; Write Byte 2: Y position. Legal Y positions are 0-255 if sprites are allowed over the border or 32-223 if not.
; Write Byte 3:
;   Bit 0: Most significant bit of X position
;   Bit 1: 1 = Enable rotation, 0 = Disable rotation
;   Bit 2: 1 = Enable Y mirror, 0 = Disable Y mirror
;   Bit 3: 1 = Enable X mirror, 0 = Disable X mirror
;   Bits 4-7: Palette offset, added to each palette index from pattern before drawing (0-15)
; Write Byte 4:
;   Bits 0-5: Pattern index (0-63)
;   Bit 6: Reserved, always set to 0
;   Bit 7: 1 = Enable visibility, 0 = Disable visibility
; Note: The high byte of the port number is ignored so that the OTIR instruction can be used. 
P8W_NX_SPRITE_ATTRIBUTE_UPLOAD equ $57
SAU3_X_POSITION_MSB equ      %00000001
SAU3_ROTATION equ            %00000010
SAU3_MIRROR_Y equ            %00000100
SAU3_MIRROR_X equ            %00001000
SAU3_PALETTE_OFFSET_MASK equ %11110000
SAU3_PALETTE_OFFSET_0 equ    %00000000
SAU3_PALETTE_OFFSET_1 equ    %00010000
SAU3_PALETTE_OFFSET_2 equ    %00100000
SAU3_PALETTE_OFFSET_3 equ    %00110000
SAU3_PALETTE_OFFSET_4 equ    %01000000
SAU3_PALETTE_OFFSET_5 equ    %01010000
SAU3_PALETTE_OFFSET_6 equ    %01100000
SAU3_PALETTE_OFFSET_7 equ    %01110000
SAU3_PALETTE_OFFSET_8 equ    %10000000
SAU3_PALETTE_OFFSET_9 equ    %10010000
SAU3_PALETTE_OFFSET_10 equ   %10100000
SAU3_PALETTE_OFFSET_11 equ   %10110000
SAU3_PALETTE_OFFSET_12 equ   %11000000
SAU3_PALETTE_OFFSET_13 equ   %11010000
SAU3_PALETTE_OFFSET_14 equ   %11100000
SAU3_PALETTE_OFFSET_15 equ   %11110000
SAU4_PATTERN_INDEX_MASK equ  %00111111
SAU4_PATTERN_INDEX_0 equ     %00000000
SAU4_PATTERN_INDEX_1 equ     %00000001
SAU4_PATTERN_INDEX_2 equ     %00000010
SAU4_PATTERN_INDEX_3 equ     %00000011
SAU4_PATTERN_INDEX_4 equ     %00000100
SAU4_PATTERN_INDEX_5 equ     %00000101
SAU4_PATTERN_INDEX_6 equ     %00000110
SAU4_PATTERN_INDEX_7 equ     %00000111
SAU4_PATTERN_INDEX_8 equ     %00001000
SAU4_PATTERN_INDEX_9 equ     %00001001
SAU4_PATTERN_INDEX_10 equ    %00001010
SAU4_PATTERN_INDEX_11 equ    %00001011
SAU4_PATTERN_INDEX_12 equ    %00001100
SAU4_PATTERN_INDEX_13 equ    %00001101
SAU4_PATTERN_INDEX_14 equ    %00001110
SAU4_PATTERN_INDEX_15 equ    %00001111
SAU4_PATTERN_INDEX_16 equ    %00010000
SAU4_PATTERN_INDEX_17 equ    %00010001
SAU4_PATTERN_INDEX_18 equ    %00010010
SAU4_PATTERN_INDEX_19 equ    %00010011
SAU4_PATTERN_INDEX_20 equ    %00010100
SAU4_PATTERN_INDEX_21 equ    %00010101
SAU4_PATTERN_INDEX_22 equ    %00010110
SAU4_PATTERN_INDEX_23 equ    %00010111
SAU4_PATTERN_INDEX_24 equ    %00011000
SAU4_PATTERN_INDEX_25 equ    %00011001
SAU4_PATTERN_INDEX_26 equ    %00011010
SAU4_PATTERN_INDEX_27 equ    %00011011
SAU4_PATTERN_INDEX_28 equ    %00011100
SAU4_PATTERN_INDEX_29 equ    %00011101
SAU4_PATTERN_INDEX_30 equ    %00011110
SAU4_PATTERN_INDEX_31 equ    %00011111
SAU4_PATTERN_INDEX_32 equ    %00100000
SAU4_PATTERN_INDEX_33 equ    %00100001
SAU4_PATTERN_INDEX_34 equ    %00100010
SAU4_PATTERN_INDEX_35 equ    %00100011
SAU4_PATTERN_INDEX_36 equ    %00100100
SAU4_PATTERN_INDEX_37 equ    %00100101
SAU4_PATTERN_INDEX_38 equ    %00100110
SAU4_PATTERN_INDEX_39 equ    %00100111
SAU4_PATTERN_INDEX_40 equ    %00101000
SAU4_PATTERN_INDEX_41 equ    %00101001
SAU4_PATTERN_INDEX_42 equ    %00101010
SAU4_PATTERN_INDEX_43 equ    %00101011
SAU4_PATTERN_INDEX_44 equ    %00101100
SAU4_PATTERN_INDEX_45 equ    %00101101
SAU4_PATTERN_INDEX_46 equ    %00101110
SAU4_PATTERN_INDEX_47 equ    %00101111
SAU4_PATTERN_INDEX_48 equ    %00110000
SAU4_PATTERN_INDEX_49 equ    %00110001
SAU4_PATTERN_INDEX_50 equ    %00110010
SAU4_PATTERN_INDEX_51 equ    %00110011
SAU4_PATTERN_INDEX_52 equ    %00110100
SAU4_PATTERN_INDEX_53 equ    %00110101
SAU4_PATTERN_INDEX_54 equ    %00110110
SAU4_PATTERN_INDEX_55 equ    %00110111
SAU4_PATTERN_INDEX_56 equ    %00111000
SAU4_PATTERN_INDEX_57 equ    %00111001
SAU4_PATTERN_INDEX_58 equ    %00111010
SAU4_PATTERN_INDEX_59 equ    %00111011
SAU4_PATTERN_INDEX_60 equ    %00111100
SAU4_PATTERN_INDEX_61 equ    %00111101
SAU4_PATTERN_INDEX_62 equ    %00111110
SAU4_PATTERN_INDEX_63 equ    %00111111
SAU4_VISIBLE equ             %10000000

; Sprite pattern upload, Write
; Sprite patterns are 16x16 (256 bytes) and sent in left-to-right, top-to-bottom order.
; Each byte is the offset (0-255) within the active sprite palette. After sending 256 bytes, the target sprite is auto-incremented.
; This auto-increment is independent of other sprite registers.
; Note: The high byte of the port number is ignored so that the OTIR instruction can be used. 
P8W_NX_SPRITE_PATTERN_UPLOAD equ $5B


; *** ZX Spectrum Next 16-bit ports ***

; I2C Serial Clock Line (SCL), Read/Write
; Write Bit 0: Set state of SCL line
; Read Bit 0: Get state of SCL line
; Note: I2C uses open collector outputs; the idle, released state is 1. So if you want to read the line, you should set it to 1 first.
P16RW_NX_I2C_CLOCK equ $103B
I2CC_SET equ   %00000001
I2CC_RESET equ %00000000

; I2C Serial Data Line (SDA), Read/Write
; Write Bit 0: Set state of SDA line
; Read Bit 0: Get state of SDA line
; Note: I2C uses open collector outputs; the idle, released state is 1. So if you want to read the line, you should set it to 1 first.
P16RW_NX_I2C_DATA equ $113B
I2CD_SET equ   %00000001
I2CD_RESET equ %00000000

; Layer 2 access, Write
; Write Bit 0: 1 = Enable Layer 2 write paging, 0 = Disable Layer 2 write paging
; Write Bit 1: 1 = Layer 2 visible, 0 = Layer 2 invisible
; Write Bit 3: 1 = Display Shadow Layer 2, 0 = Display Normal Layer 2
; Write Bits 6-7: Video RAM bank select (0-2) for write paging
P16W_NX_LAYER2_ACCESS equ $123B
L2A_WRITE_PAGING equ %00000001
L2A_VISIBLE equ      %00000010
L2A_SHADOW equ       %00001000
L2A_BANK_MASK equ    %11000000
L2A_BANK_0 equ       %00000000
L2A_BANK_1 equ       %01000000
L2A_BANK_2 equ       %10000000

; Serial port transmit, Read/Write
; Write Byte: Send byte to serial port
; Read Bit 0: 1 = No data in recieve buffer, 0 = Data available in recieve buffer
; Note: Officially the serial port is connected to the optional WiFi module
P16RW_NX_UART_TX equ $133B
UTX_NOT_DATA_AVAILABLE equ %00000001

; Serial port receive, Read/Write
; Read Byte: Get the next byte in the recieve buffer. What is returned when the buffer is empty???
; Write Byte: Set the communication speed;
;   0 = 115200 (default at reset), 1 = 57600, 2 = 38400, 3 = 19200, 4 = 9600, 5 = 4800, 6 = 2400
; Note: Officially the serial port is connected to the optional WiFi module
P16RW_NX_UART_RX equ $143B
URX_SPEED_115200 equ 0
URX_SPEED_57600 equ  1
URX_SPEED_38400 equ  2
URX_SPEED_19200 equ  3
URX_SPEED_9600 equ   4
URX_SPEED_4800 equ   5
URX_SPEED_2400 equ   6

; Next Register select, Write
; Write Byte: Set the Next Feature Control Register to read or write with the P16RW_NX_NEXT_REGISTER_VALUE port.
P16W_NX_NEXT_REGISTER_SELECT equ $243B

; Next Register value, Read/Write
; Read or write the currently selected Next Feature Control Register as specified by the P16W_NX_NEXT_REGISTER_SELECT port.
P16RW_NX_NEXT_REGISTER_VALUE equ $253B

; Sprite status / slot select, Read/Write
; Selects the active sprite slot and palette address, returns the sprite status.
; Write Byte: Set the sprite slot used by ports P8W_NX_SPRITE_ATTRIBUTE_UPLOAD and P8W_NX_SPRITE_PATTERN_UPLOAD.
;   Once written, these ports may auto-increment the sprite number they are addressing.
;   This auto-increment happens independently and so the two ports may end up addressing different sprites as a result.
;   A write to this port will resynchronise them to the same sprite.
;   When this port is written to, it also resets the P8W_NX_SPRITE_PALETTE_UPLOAD port to the start of the first palette index.
; Read Bit 0: 1 = One or more sprites overlap, 0 = No sprites overlap; The sprite overlap only applies to non-transparent pixels.
; Read Bit 1: 1 = More than 12 sprites share a horizontal line, 0 = 12 or less sprites share a horizontal line.
P16RW_NX_SPRITE_SLOT_SELECT equ $303B
P16RW_NX_SPRITE_STATUS equ      $303B
SS_COLLISION equ            %00000001
SS_MAX_SPRITES_PER_LINE equ %00000010

; Next memory bank select (128K compatible), Write
; Write Bits 0-2: 3 MSBs of the 16K bank paged into address $C000.
;   Used in conjunction with the original 128K P16W_MEMORY_PAGING port.
P16W_NX_NEXT_MEMORY_BANK equ $DFFD
NMB_16K_BANK_MASK equ   %00000111
NMB_16K_BANK_ADD_0 equ  %00000000
NMB_16K_BANK_ADD_8 equ  %00000001
NMB_16K_BANK_ADD_16 equ %00000010
NMB_16K_BANK_ADD_24 equ %00000011
NMB_16K_BANK_ADD_32 equ %00000100
NMB_16K_BANK_ADD_40 equ %00000101
NMB_16K_BANK_ADD_48 equ %00000110
NMB_16K_BANK_ADD_56 equ %00000111

; Turbo Sound Next, Write
; Write Bits 0-1: Select active AY-3-8912 sound chip (0-2) (3 is unused)
;   00 = AY-3-8912 Chip 0
;   01 = AY-3-8912 Chip 1
;   10 = AY-3-8912 Chip 2
; Write Bits 2-4: Must always be 1
; Write Bit 5: 1 = Enable right audio, 0 = Disable right audio
; Write Bit 6: 1 = Enable left audio, 0 = Disable left audio
; Write Bit 7: 1 = Select active sound chip, 0 = Select register number of active sound chip
; or
; Write Byte: When bit 7 is 0; the value written selects the register number to access from the active sound chip.
;   Therefore the valid register number range is 0-127, inclusive, however the AY-3-8912 only supports 17 registers (0-16)
; After register selection with this port, the register value should be written to the standard 128K P16RW_AY_REGISTER_VALUE port.
; Note: This is the same port as the standard 128K P16W_AY_REGISTER_SELECT port. On a 128K machine, only register selection is supported.
P16W_NX_TURBO_SOUND_NEXT equ $FFFD
TSN_ACTIVE_CHIP_MASK equ %00000011
TSN_ACTIVE_CHIP_0 equ    %00000000
TSN_ACTIVE_CHIP_1 equ    %00000001
TSN_ACTIVE_CHIP_2 equ    %00000010
TSN_ENABLE_RIGHT equ     %00100000
TSN_ENABLE_LEFT equ      %01000000
TSN_SELECT_CHIP equ      %10011100


; *** ZX Spectrum Next Memory Locations ***

; The memory address of the currently paged in Layer2 16K bank.
; The bank to page in is controlled by the P16W_NX_LAYER2_ACCESS port.
; As this area overlays the ROM; a write to this address range will update Layer2,
; but a read will return the appropriate part of the currently paged in ROM.
M_NX_LAYER2_ACCESS_START equ $0000
M_NX_LAYER2_ACCESS_END equ   $3FFF
M_NX_LAYER2_ACCESS_SIZE equ  $4000

; Memory slot start addresses
; Each slot is 8K in size
M_NX_MEMORY_SLOT_0 equ    $0000
M_NX_MEMORY_SLOT_1 equ    $2000
M_NX_MEMORY_SLOT_2 equ    $4000
M_NX_MEMORY_SLOT_3 equ    $6000
M_NX_MEMORY_SLOT_4 equ    $8000
M_NX_MEMORY_SLOT_5 equ    $A000
M_NX_MEMORY_SLOT_6 equ    $C000
M_NX_MEMORY_SLOT_7 equ    $E000
M_NX_MEMORY_SLOT_SIZE equ $2000

; *** ZX Spectrum Next feature control registers ***

; Machine ID, Read
; Identifies TBBlue board type. Should always be 10 on Next.
; Read Byte: The TBBlue board type
;   1 = Terasic Altera DE-1, 2 = Terasic Altera DE-2, 5 = FBLabs, 6 = VTrucco,
;   7 = WXEDA, 8 = Emulator, 9 = ZXUNO, 10 = Spectrum Next, 11 = Multicore
NXR_MACHINE_ID equ $00
MID_TERASIC_ALTERA_DE_1 equ 1
MID_TERASIC_ALTERA_DE_2 equ 2
MID_FBLABS equ 5
MID_VTRUCCO equ 6
MID_WXEDA equ 7
MID_EMULATOR equ 8
MID_ZXUNO equ 9
MID_SPECTRUM_NEXT equ 10
MID_MULTICORE equ 11

; Next version, Read
; Indentifies FPGA image version
; Read Bits 0-3: Minor version number (0-15)
; Read Bits 4-7: Major version number (0-15)
; Note: See register NXR_CORE_VERSION ($0E) for sub minor version number.
NXR_NEXT_VERSION equ $01
NV_MINOR_MASK equ %00001111
NV_MAJOR_MASK equ %11110000

; Next reset, Read/Write
; Identifies the type of last reset. Can be written to force reset.
; Read Bit 0: 1 = Soft reset, 0 = Not soft reset
; Read Bit 1: 1 = Hard reset, 0 = Not hard reset
; Read Bit 2: 1 = Power-on reset, 0 = Not power-on reset
; Write Bit 0: 1 = Force soft reset, 0 = Don't force soft reset
; Write Bit 1: 1 = Force hard reset, 0 = Don't force hard reset
; Write Bit 2: Ignored
; Write Bits 3-7: Reserved, always set to 0
NXRW_NEXT_RESET equ $02
NR_SOFT equ     %00000001
NR_HARD equ     %00000010
NR_POWER_ON equ %00000100

; Machine type, Write
; Only valid in Initial Program Loader (IPL) or config mode. Writing to this register disables the IPL.
; ($0000-$3FFF are mapped to RAM instead of the internal ROM)
; Write Bits 0-2: Machine type;
;   000 = Config mode, 001 = ZX Spectrum 48K, 010 = ZX Spectrum 128K, 011 = ZX Spectrum +3e, 100 = Pentagon
; Write Bit 3: Reserved, always set to 0
; Write Bits 4-6: Machine timing;
;   000-001 = ZX Spectrum 48K, 010 = ZX Spectrum 128K, 011 = ZX Spectrum +3e, 100 = Pentagon
; Write Bit 7: 1 = Lock timing, 0 = Don't lock timing
NXW_MACHINE_TYPE equ $03
MT_TYPE_MASK equ       %00000111
MT_TYPE_CONFIG equ     %00000000
MT_TYPE_48K equ        %00000001
MT_TYPE_128K equ       %00000010
MT_TYPE_PLUS3E equ     %00000011
MT_TYPE_PENTAGON equ   %00000100
MT_TIMING_MASK equ     %01110000
MT_TIMING_48K equ      %00000000
MT_TIMING_48K_ALT equ  %00010000
MT_TIMING_128K equ     %00100000
MT_TIMING_PLUS3E equ   %00110000
MT_TIMING_PENTAGON equ %01000000
MT_LOCK_TIMING equ     %10000000

; ROM mapping, Write
; In config mode (not IPL), allows RAM to be mapped to ROM area.
; Write Bits 0-5: RAM page number mapped into $0000-$3FFF (0-63)
; Write Bits 6-7: Reserved, always set to 0
; Note: 64 x 16K pages = 1024K. Value reset to 0 after Power-on or hard reset.
NXW_ROM_MAPPING equ $04
RM_PAGE_MASK equ %00111111
RM_PAGE_0 equ    %00000000
RM_PAGE_1 equ    %00000001
RM_PAGE_2 equ    %00000010
RM_PAGE_3 equ    %00000011
RM_PAGE_4 equ    %00000100
RM_PAGE_5 equ    %00000101
RM_PAGE_6 equ    %00000110
RM_PAGE_7 equ    %00000111
RM_PAGE_8 equ    %00001000
RM_PAGE_9 equ    %00001001
RM_PAGE_10 equ   %00001010
RM_PAGE_11 equ   %00001011
RM_PAGE_12 equ   %00001100
RM_PAGE_13 equ   %00001101
RM_PAGE_14 equ   %00001110
RM_PAGE_15 equ   %00001111
RM_PAGE_16 equ   %00010000
RM_PAGE_17 equ   %00010001
RM_PAGE_18 equ   %00010010
RM_PAGE_19 equ   %00010011
RM_PAGE_20 equ   %00010100
RM_PAGE_21 equ   %00010101
RM_PAGE_22 equ   %00010110
RM_PAGE_23 equ   %00010111
RM_PAGE_24 equ   %00011000
RM_PAGE_25 equ   %00011001
RM_PAGE_26 equ   %00011010
RM_PAGE_27 equ   %00011011
RM_PAGE_28 equ   %00011100
RM_PAGE_29 equ   %00011101
RM_PAGE_30 equ   %00011110
RM_PAGE_31 equ   %00011111
RM_PAGE_32 equ   %00100000
RM_PAGE_33 equ   %00100001
RM_PAGE_34 equ   %00100010
RM_PAGE_35 equ   %00100011
RM_PAGE_36 equ   %00100100
RM_PAGE_37 equ   %00100101
RM_PAGE_38 equ   %00100110
RM_PAGE_39 equ   %00100111
RM_PAGE_40 equ   %00101000
RM_PAGE_41 equ   %00101001
RM_PAGE_42 equ   %00101010
RM_PAGE_43 equ   %00101011
RM_PAGE_44 equ   %00101100
RM_PAGE_45 equ   %00101101
RM_PAGE_46 equ   %00101110
RM_PAGE_47 equ   %00101111
RM_PAGE_48 equ   %00110000
RM_PAGE_49 equ   %00110001
RM_PAGE_50 equ   %00110010
RM_PAGE_51 equ   %00110011
RM_PAGE_52 equ   %00110100
RM_PAGE_53 equ   %00110101
RM_PAGE_54 equ   %00110110
RM_PAGE_55 equ   %00110111
RM_PAGE_56 equ   %00111000
RM_PAGE_57 equ   %00111001
RM_PAGE_58 equ   %00111010
RM_PAGE_59 equ   %00111011
RM_PAGE_60 equ   %00111100
RM_PAGE_61 equ   %00111101
RM_PAGE_62 equ   %00111110
RM_PAGE_63 equ   %00111111

; Peripheral 1, Read/Write
; Sets joystick mode, video frequency, scanlines and scandoubler.
; Bit 0: 1 = Enable scandoubler, 0 = Disable scandoubler
; Bit 1: 1 = Enable scanlines, 0 = Disable scanlines
; Bit 2: 1 = 60Hz display, 0 = 50Hz display
; Bit 3: Reserved, always set to 0
; Bits 4-5: Joystick 1 mode
; Bits 6-7: Joystick 2 mode
;   Joysticks modes are;
;   00 = Sinclair joystick (Joystick 1 maps to keys 1,2,3,4,5, Joystick 2 maps to keys 6,7,8,9,0)
;   01 = Kempston joystick. Only one joystick can be Kempston.
;   10 = Cursor joystick (maps to keys 5,6,7,8,0). Only one joystick can be Cursor.
NXRW_PERIPHERAL_1 equ $05
P1_SCANDOUBLER equ         %00000001
P1_SCANLINES equ           %00000010
P1_60HZ equ                %00000100
P1_JOYSTICK_1_MASK equ     %00110000
P1_JOYSTICK_1_SINCLAIR equ %00000000
P1_JOYSTICK_1_KEMPSTON equ %00010000
P1_JOYSTICK_1_CURSOR equ   %00100000
P1_JOYSTICK_2_MASK equ     %11000000
P1_JOYSTICK_2_SINCLAIR equ %00000000
P1_JOYSTICK_2_KEMPSTON equ %01000000
P1_JOYSTICK_2_CURSOR equ   %10000000

; Peripheral 2, Read/Write
; Enables acceleration, Lightpen, DivMMC, Multiface, mouse and AY audio.
; Bit 0: 1 = Enable audio, 0 = Disable audio
; Bit 1: 1 = AY audio chip, 0 = YM audio chip
; Bit 2: 1 = PS/2 mouse, 0 = PS/2 keyboard
; Bit 3: 1 = Enable Multiface, 0 = Disable Multiface
; Bit 4: 1 = Enable DivMMC automatic paging, 0 = Disable DivMMC automatic paging
; Bit 5: 1 = Enable Lightpen, 0 = Disable Lightpen
; Bit 6: 1 = JAP DAC chip mode, 0 = I2S DAC chip mode (VTrucco board ONLY)
; Bit 7: 1 = Enable turbo mode, 0 = Disable turbo mode
NXRW_PERIPHERAL_2 equ $06
P2_ENABLE_AUDIO equ  %00000001
P2_AY_AUDIO_CHIP equ %00000010
P2_PS2_MOUSE     equ %00000100
P2_MULTIFACE     equ %00001000
P2_DIVMMC_PAGING equ %00010000
P2_LIGHTPEN equ      %00100000
P2_JAP_DAC_MODE equ  %01000000
P2_TURBO equ         %10000000

; Turbo mode, Read/Write
; Bits 0-1: Turbo speed; 00 = 3.5MHz, 01 = 7Mhz, 10 = 14MHz
; Note: Reset to 00 after power-on or hard reset.
NXRW_TURBO_MODE equ $07
TM_SPEED_MASK equ   %00000011
TM_SPEED_3_5MHZ equ %00000000
TM_SPEED_7MHZ equ   %00000001
TM_SPEED_14MHZ equ  %00000010

; Peripheral 3, Read/Write
; Bit 0: Reserved, always set to 0
; Bit 1: 1 = Enable TurboSound, 0 = Disable TurboSound; Disabled after Power on Reset or Hard Reset
; Bit 2: 1 = Enable Timex video modes, 0 = Disable Timex video modes; Disabled after Power on Reset or Hard Reset
; Bit 3: 1 = Enable SpecDrum/Covox, 0 = Disable SpecDrum/Covox; Disabled after Power on Reset or Hard Reset
; Bit 4: 1 = Enable internal speaker, 0 = Disable internal speaker; Enabled after Power on Reset or Hard Reset
; Bit 5: 1 = ACB stereo mode, 0 = ABC stereo mode; ABC after Power on Reset or Hard Reset
; Bit 6: 1 = Disable memory contention, 0 = Enable memory contention; Enabled after Reset
; Bit 7: 128K paging enable (Inverse of P16W_MEMORY_PAGING port, bit 5)
;   Unlike the paging lock in port P16W_MEMORY_PAGING, this may be enabled or disabled at any time.
;   Set to 1 to disable the locked paging.
NXRW_PERIPHERAL_3 equ $08
P3_TURBOSOUND equ                %00000010
P3_TIMEX_VIDEO equ               %00000100
P3_SPECDRUM equ                  %00001000
P3_SPEAKER equ                   %00010000
P3_ACB_STEREO equ                %00100000
P3_DISABLE_MEMORY_CONTENTION equ %01000000
P3_128K_PAGING equ               %10000000

; Core version, Read
; Read Byte: Sub minor version number
NXR_CORE_VERSION equ $0E

; Anti-brick system, Read/Write
; Only on ZX Next board (not other TBBlue boards)
; Read Bit 0: 1 = Multiface button pressed, 0 = Multiface button not pressed
; Read Bit 1: 1 = DivMMC button pressed, 0 = DivMMC button not pressed
; Bits 2-6: Reserved, always set to 0
; Write Bit 7: 1 = Start normal core, 0 = Do not start normal core
NXRW_ANTI_BRICK equ $10
AB_MULTIFACE_BUTTON equ  %00000001
AB_DIVMMC_BUTTON equ     %00000010
AB_START_NORMAL_CORE equ %10000000

; Layer 2 RAM page, Read/Write
; Bits 0-5: SRAM page (0-63)
; Bits 6-7: Reserved, always set to 0
; Note: Defaults to page 8 after reset
NXRW_LAYER2_RAM_PAGE equ $12
L2RP_SRAM_PAGE_MASK equ %00111111
L2RP_SRAM_PAGE_0 equ    %00000000
L2RP_SRAM_PAGE_1 equ    %00000001
L2RP_SRAM_PAGE_2 equ    %00000010
L2RP_SRAM_PAGE_3 equ    %00000011
L2RP_SRAM_PAGE_4 equ    %00000100
L2RP_SRAM_PAGE_5 equ    %00000101
L2RP_SRAM_PAGE_6 equ    %00000110
L2RP_SRAM_PAGE_7 equ    %00000111
L2RP_SRAM_PAGE_8 equ    %00001000
L2RP_SRAM_PAGE_9 equ    %00001001
L2RP_SRAM_PAGE_10 equ   %00001010
L2RP_SRAM_PAGE_11 equ   %00001011
L2RP_SRAM_PAGE_12 equ   %00001100
L2RP_SRAM_PAGE_13 equ   %00001101
L2RP_SRAM_PAGE_14 equ   %00001110
L2RP_SRAM_PAGE_15 equ   %00001111
L2RP_SRAM_PAGE_16 equ   %00010000
L2RP_SRAM_PAGE_17 equ   %00010001
L2RP_SRAM_PAGE_18 equ   %00010010
L2RP_SRAM_PAGE_19 equ   %00010011
L2RP_SRAM_PAGE_20 equ   %00010100
L2RP_SRAM_PAGE_21 equ   %00010101
L2RP_SRAM_PAGE_22 equ   %00010110
L2RP_SRAM_PAGE_23 equ   %00010111
L2RP_SRAM_PAGE_24 equ   %00011000
L2RP_SRAM_PAGE_25 equ   %00011001
L2RP_SRAM_PAGE_26 equ   %00011010
L2RP_SRAM_PAGE_27 equ   %00011011
L2RP_SRAM_PAGE_28 equ   %00011100
L2RP_SRAM_PAGE_29 equ   %00011101
L2RP_SRAM_PAGE_30 equ   %00011110
L2RP_SRAM_PAGE_31 equ   %00011111
L2RP_SRAM_PAGE_32 equ   %00100000
L2RP_SRAM_PAGE_33 equ   %00100001
L2RP_SRAM_PAGE_34 equ   %00100010
L2RP_SRAM_PAGE_35 equ   %00100011
L2RP_SRAM_PAGE_36 equ   %00100100
L2RP_SRAM_PAGE_37 equ   %00100101
L2RP_SRAM_PAGE_38 equ   %00100110
L2RP_SRAM_PAGE_39 equ   %00100111
L2RP_SRAM_PAGE_40 equ   %00101000
L2RP_SRAM_PAGE_41 equ   %00101001
L2RP_SRAM_PAGE_42 equ   %00101010
L2RP_SRAM_PAGE_43 equ   %00101011
L2RP_SRAM_PAGE_44 equ   %00101100
L2RP_SRAM_PAGE_45 equ   %00101101
L2RP_SRAM_PAGE_46 equ   %00101110
L2RP_SRAM_PAGE_47 equ   %00101111
L2RP_SRAM_PAGE_48 equ   %00110000
L2RP_SRAM_PAGE_49 equ   %00110001
L2RP_SRAM_PAGE_50 equ   %00110010
L2RP_SRAM_PAGE_51 equ   %00110011
L2RP_SRAM_PAGE_52 equ   %00110100
L2RP_SRAM_PAGE_53 equ   %00110101
L2RP_SRAM_PAGE_54 equ   %00110110
L2RP_SRAM_PAGE_55 equ   %00110111
L2RP_SRAM_PAGE_56 equ   %00111000
L2RP_SRAM_PAGE_57 equ   %00111001
L2RP_SRAM_PAGE_58 equ   %00111010
L2RP_SRAM_PAGE_59 equ   %00111011
L2RP_SRAM_PAGE_60 equ   %00111100
L2RP_SRAM_PAGE_61 equ   %00111101
L2RP_SRAM_PAGE_62 equ   %00111110
L2RP_SRAM_PAGE_63 equ   %00111111

; Layer 2 RAM shadow page, Read/Write
; Bits 0-5: SRAM page (0-63)
; Bits 6-7: Reserved, always set to 0
; Note: Defaults to page 11 after reset
NXRW_LAYER2_RAM_SHADOW_PAGE equ $13
L2RSP_SRAM_PAGE_MASK equ %00111111
L2RSP_SRAM_PAGE_0 equ    %00000000
L2RSP_SRAM_PAGE_1 equ    %00000001
L2RSP_SRAM_PAGE_2 equ    %00000010
L2RSP_SRAM_PAGE_3 equ    %00000011
L2RSP_SRAM_PAGE_4 equ    %00000100
L2RSP_SRAM_PAGE_5 equ    %00000101
L2RSP_SRAM_PAGE_6 equ    %00000110
L2RSP_SRAM_PAGE_7 equ    %00000111
L2RSP_SRAM_PAGE_8 equ    %00001000
L2RSP_SRAM_PAGE_9 equ    %00001001
L2RSP_SRAM_PAGE_10 equ   %00001010
L2RSP_SRAM_PAGE_11 equ   %00001011
L2RSP_SRAM_PAGE_12 equ   %00001100
L2RSP_SRAM_PAGE_13 equ   %00001101
L2RSP_SRAM_PAGE_14 equ   %00001110
L2RSP_SRAM_PAGE_15 equ   %00001111
L2RSP_SRAM_PAGE_16 equ   %00010000
L2RSP_SRAM_PAGE_17 equ   %00010001
L2RSP_SRAM_PAGE_18 equ   %00010010
L2RSP_SRAM_PAGE_19 equ   %00010011
L2RSP_SRAM_PAGE_20 equ   %00010100
L2RSP_SRAM_PAGE_21 equ   %00010101
L2RSP_SRAM_PAGE_22 equ   %00010110
L2RSP_SRAM_PAGE_23 equ   %00010111
L2RSP_SRAM_PAGE_24 equ   %00011000
L2RSP_SRAM_PAGE_25 equ   %00011001
L2RSP_SRAM_PAGE_26 equ   %00011010
L2RSP_SRAM_PAGE_27 equ   %00011011
L2RSP_SRAM_PAGE_28 equ   %00011100
L2RSP_SRAM_PAGE_29 equ   %00011101
L2RSP_SRAM_PAGE_30 equ   %00011110
L2RSP_SRAM_PAGE_31 equ   %00011111
L2RSP_SRAM_PAGE_32 equ   %00100000
L2RSP_SRAM_PAGE_33 equ   %00100001
L2RSP_SRAM_PAGE_34 equ   %00100010
L2RSP_SRAM_PAGE_35 equ   %00100011
L2RSP_SRAM_PAGE_36 equ   %00100100
L2RSP_SRAM_PAGE_37 equ   %00100101
L2RSP_SRAM_PAGE_38 equ   %00100110
L2RSP_SRAM_PAGE_39 equ   %00100111
L2RSP_SRAM_PAGE_40 equ   %00101000
L2RSP_SRAM_PAGE_41 equ   %00101001
L2RSP_SRAM_PAGE_42 equ   %00101010
L2RSP_SRAM_PAGE_43 equ   %00101011
L2RSP_SRAM_PAGE_44 equ   %00101100
L2RSP_SRAM_PAGE_45 equ   %00101101
L2RSP_SRAM_PAGE_46 equ   %00101110
L2RSP_SRAM_PAGE_47 equ   %00101111
L2RSP_SRAM_PAGE_48 equ   %00110000
L2RSP_SRAM_PAGE_49 equ   %00110001
L2RSP_SRAM_PAGE_50 equ   %00110010
L2RSP_SRAM_PAGE_51 equ   %00110011
L2RSP_SRAM_PAGE_52 equ   %00110100
L2RSP_SRAM_PAGE_53 equ   %00110101
L2RSP_SRAM_PAGE_54 equ   %00110110
L2RSP_SRAM_PAGE_55 equ   %00110111
L2RSP_SRAM_PAGE_56 equ   %00111000
L2RSP_SRAM_PAGE_57 equ   %00111001
L2RSP_SRAM_PAGE_58 equ   %00111010
L2RSP_SRAM_PAGE_59 equ   %00111011
L2RSP_SRAM_PAGE_60 equ   %00111100
L2RSP_SRAM_PAGE_61 equ   %00111101
L2RSP_SRAM_PAGE_62 equ   %00111110
L2RSP_SRAM_PAGE_63 equ   %00111111

; Global transparency colour, Read/Write
; Byte: Transparency colour value
; Note: Defaults to Pure magenta ($E3, %11100011) after reset
;   This value is 8-bit only, so the transparency is compared only to the upper 8-bits of the final colour).
;   This register only affects Layer 2, ULA and LoRes. Sprites use register NXRW_SPRITE_GLOBAL_TRANSPARENCY for transparency.
NXRW_GLOBAL_TRANSPARENCY equ $14

; Sprite and Layers system, Read/Write
; Bit 0: 1 = Visible sprites, 0 = Invisible sprites
; Bit 1: 1 = Sprites over border, 0 = Sprites under border
; Bits 2-4: Set layer priorities;
;   000 = Sprites > Layer 2 > ULA
;   001 = Layer 2 > Sprites > ULA
;   010 = Sprites > ULA > Layer 2
;   011 = Layer 2 > ULA > Sprites
;   100 = ULA > Sprites > Layer 2
;   101 = ULA > Layer 2> Sprites
; Bits 5-6: Reserved, always set to 0
; Bit 7: 1 = Enable LoRes mode, 0 = Disable LoRes mode; (128 x 96 x 256 colours)
NXRW_SPRITE_LAYERS_SYSTEM equ $15
SLS_SPRITES_VISIBLE equ     %00000001
SLS_SPRITES_OVER_BORDER equ %00000010
SLS_LAYER_PRIORITY_MASK equ %00011100
SLS_LAYER_PRIORITY_SLU equ  %00000000
SLS_LAYER_PRIORITY_LSU equ  %00000100
SLS_LAYER_PRIORITY_SUL equ  %00001000
SLS_LAYER_PRIORITY_LUS equ  %00001100
SLS_LAYER_PRIORITY_USL equ  %00010000
SLS_LAYER_PRIORITY_ULS equ  %00010100
SLS_LORES_MODE equ          %10000000

; Layer 2 offset X
; Byte: X offset (0-255)
NXRW_LAYER2_OFFSET_X equ $16

; Layer 2 offset Y
; Byte: Y offset (0-191)
NXRW_LAYER2_OFFSET_Y equ $17

; Layer 2 clip window
; Bounds are sent as 4 bytes in the following order;
; Write Byte 1: X1 position
; Write Byte 2: X2 position
; Write Byte 3: Y1 position
; Write Byte 4: Y2 position
; Note: Defaults to 0, 255, 0, 191 after a reset
NXW_CLIP_WINDOW_LAYER2 equ $18

; Sprites clip window
; Bounds are sent as 4 bytes in the following order;
; Write Byte 1: X1 position
; Write Byte 2: X2 position
; Write Byte 3: Y1 position
; Write Byte 4: Y2 position
; Note: Defaults to 0, 255, 0, 191 after a reset
;   The sprites clip window is only used when the NXRW_SPRITE_LAYERS_SYSTEM port SLS_SPRITES_OVER_BORDER bit is set.
NXW_CLIP_WINDOW_SPRITES equ $19

; ULA/LoRes clip window
; Bounds are sent as 4 bytes in the following order;
; Write Byte 1: X1 position
; Write Byte 2: X2 position
; Write Byte 3: Y1 position
; Write Byte 4: Y2 position
NXW_CLIP_WINDOW_ULA_LORES equ $1A

; Clip window control
; Write Bit 0: 1 = Reset the NXW_CLIP_WINDOW_LAYER2 port index, 0 = Don't reset the NXW_CLIP_WINDOW_LAYER2 port index
; Write Bit 1: 1 = Reset the NXW_CLIP_WINDOW_SPRITES port index, 0 = Don't reset the NXW_CLIP_WINDOW_SPRITES port index
; Write Bit 2: 1 = Reset the NXW_CLIP_WINDOW_ULA_LORES port index, 0 = Don't reset the NXW_CLIP_WINDOW_ULA_LORES port index
; Write Bits 3-7: Reserved, always set to 0
NXW_CLIP_WINDOW_CONTROL equ $1C
CWC_RESET_LAYER2_INDEX equ    %00000001
CWC_RESET_SPRITES_INDEX equ   %00000010
CWC_RESET_ULA_LORES_INDEX equ %00000100

; Active video line (Most Significant Bit), Read
; Read Bit 0: Active video line Most Significant Bit
; Read Bits 1-7: Reserved, always set to 0
NXR_ACTIVE_VIDEO_LINE_MSB equ $1E
AVLM_MSB_SET equ %00000001

; Active video line (Least Significant Byte), Read
; Read Byte: Active video line Least Significant Byte (0-255)
NXR_ACTIVE_VIDEO_LINE_LSB equ $1F

; Line interrupt control, Read/Write
; Bit 0: Most Significant Bit of Line Interrupt value
; Bit 1: 1 = Enable line interrupt, 0 = Disable line interrupt
; Bit 2: 1 = Disable original ULA interrupt, 0 = Enable original ULA interrupt
; Bits 3-6: Reserved, always set to 0
; Read Bit 7: 1 = Interrupt currently active, 0 = Interrupt not currently active; (Operational even if the processor has interrupts disabled)
NXRW_LINE_INTERRUPT_CONTROL equ $22
LIC_LINE_INTERRUPT_VALUE_MSB equ %00000001
LIC_ENABLE_LINE_INTERRUPT equ    %00000010
LIC_DISABLE_ULA_INTERRUPT equ    %00000100
LIC_INTERRUPT_ACTIVE equ         %10000000

; Line interrupt value (Least Significant Byte), Read/Write
; Byte: Line interrupt value Least Significant Byte (0-255)
NXRW_LINE_INTERRUPT_VALUE_LSB equ $23

; Keymap high address, Write
; Write Bit 0: Most Significant Bit of Keymap Address
; Write Bits 1-7: Reserved, always set to 0
NXW_KEYMAP_HIGH_ADDRESS equ $28

; Keymap low address, Write
; Write Byte: Keymap Address Least Significant Byte (0-255)
NXW_KEYMAP_LOW_ADDRESS equ $29

; Keymap high data, Write
; Write Bit 0: Most Significant Bit of Keymap Data
; Write Bits 1-7: Reserved, always set to 0
NXW_KEYMAP_HIGH_DATA equ $2A

; Keymap low data, Write
; Write Byte: Keymap Data Least Significant Byte (0-255)
; Note: Writing to this register will auto-increment the NXW_KEYMAP_LOW_ADDRESS (and possibly NXW_KEYMAP_HIGH_ADDRESS, as required)
NXW_KEYMAP_LOW_DATA equ $2B

; SpecDrum (SoundDrive) P8RW_SPECDRUM_DAC port ($DF) mirror, Write
; Write Byte: Data to be sent to SpecDrum
; Note: This register can be used to send data to the SpecDrum using the Copper co-processor
NXW_SPECDRUM_DAC_MIRROR equ $2D

; LoRes layer offset X, Read/Write
; Write Byte: X offset (0-255)
; Note: As the width of the LoRes layer is 128 pixels, this register is specified in half-pixels,
;   at the same resolution as Layer 2.
NXRW_LORES_LAYER_OFFSET_X equ $32

; LoRes layer offset Y, Read/Write
; Write Byte: Y offset (0-191)
; Note: As the height of the LoRes layer is 96 pixels, this register is specified in half-pixels,
;   at the same resolution as Layer 2.
NXRW_LORES_LAYER_OFFSET_Y equ $33

; Palette index, Read/Write
; Byte: The palette index to change with the NXW_PALETTE_VALUE register
; Note: 0 to 127 indexes are ink colours and 128 to 255 indexes are paper colours.
;   (Except "full ink" colour mode, then all values 0 to 255 are inks)
;   Border colours are the same as paper 0 to 7, indexes 128 to 135, even in full ink mode. 
;   (Ink and paper concept only applies to Enhanced ULA palette. Layer 2 and Sprite palettes work as "full ink" mode)
NXRW_PALETTE_INDEX equ $40

; Palette value (8-bit colour), Read/Write
; Byte: The colour for the palette index currently selected by the NXW_PALETTE_INDEX register in R3G3B2 format.
; Note: The missing lowest blue bit (of the 9-bit colour) will be an OR between bit 1 and bit 0.
;   If you wish to specify a 9-bit colour (R3G3B3), then use the NXW_PALETTE_VALUE_9BIT register instead of this one.
;   After writing to this register, the palette index register NXW_PALETTE_INDEX will be auto-incremented.
;   The palette will not be reset to defaults by a Soft Reset, only a Hard or Power-On Reset.
NXRW_PALETTE_VALUE_8BIT equ $41

; Palette format, Read/Write
; Byte: Number of the last ink colour entry in the palette (1, 3, 7, 15, 31, 63, 127 or 255)
; Note: The value 255 enables the "full ink" colour mode and all the palette entries will be inks,
;   but the paper will still be the colour at index 128.
;   This format only applies to the Enhanced ULA palette. Layer 2 and Sprite palettes always use "full ink".
NXRW_PALETTE_FORMAT equ $42

; Palette control, Read/Write
; Bit 0: 1 = Disable video flash attribute, 0 = Enable video flash attribute; Enabled after Reset
; Bit 1: 1 = ULA secondary palette, 0 = ULA primary palette
; Bit 2: 1 = Layer 2 secondary palette, 0 = Layer 2 primary palette
; Bit 3: 1 = Sprites secondary palette, 0 = Sprites primary palette
; Bits 4-6: Select the palette to read or write;
;   000 = ULA primary palette
;   001 = Layer 2 primary palette
;   010 = Sprites primary palette
;   100 = ULA secondary palette
;   101 = Layer 2 secondary palette
;   110 = Sprites secondary palette
; Bit 7: 1 = Disable palette write auto-increment, 0 = Enable palette write auto-increment
NXRW_PALETTE_CONTROL equ $43
PC_DISABLE_FLASH equ                %00000001
PC_USE_ULA_1ST_PALETTE equ          %00000000
PC_USE_ULA_2ND_PALETTE equ          %00000010
PC_USE_LAYER2_1ST_PALETTE equ       %00000000
PC_USE_LAYER2_2ND_PALETTE equ       %00000100
PC_USE_SPRITES_1ST_PALETTE equ      %00000000
PC_USE_SPRITES_2ND_PALETTE equ      %00001000
PC_PALETTE_MODIFY_MASK equ          %01110000
PC_PALETTE_MODIFY_ULA_1ST equ       %00000000
PC_PALETTE_MODIFY_LAYER2_1ST equ    %00010000
PC_PALETTE_MODIFY_SPRITES_1ST equ   %00100000
PC_PALETTE_MODIFY_ULA_2ND equ       %01000000
PC_PALETTE_MODIFY_LAYER2_2ND equ    %01010000
PC_PALETTE_MODIFY_SPRITES_2ND equ   %01100000
PC_DISABLE_WRITE_AUTO_INCREMENT equ %10000000

; Palette value (9-bit colour), Read/Write
; To set a single 9-bit colour value, two consecutive writes should be made to this register.
; Byte 1: Most Significant 8 Bits (R3G3B2)
; Byte 2:
;   Bit 0: Least Significant blue Bit (B1)
;   Bits 1-7: Reserved, always set to 0
; Note: After two consecutive writes to this register, the palette index register NXRW_PALETTE_INDEX is auto-incremented.
;   The palette will not be reset to defaults by a Soft Reset, only a Hard or Power-On Reset.
NXRW_PALETTE_VALUE_9BIT equ $44

; Transparency colour fallback, Read/Write
; Byte: Fallback colour value
; Note: Defaults to pure black ($00, %00000000) after reset.
;   The missing lowest blue bit (of the 9-bit colour) will be an OR between bit 1 and bit 0.
NXRW_TRANSPARENCY_COLOUR_FALLBACK equ $4A

; Sprite global transparency colour, Read/Write
; Byte: Transparency colour value
; Note: Defaults to Pure magenta ($E3, %11100011) after reset
;   This value is 8-bit only, so the transparency is compared only to the upper 8-bits of the final colour).
;   This register only affects sprites. Layer 2, ULA and LoRes use register NXRW_GLOBAL_TRANSPARENCY for transparency.
NXRW_SPRITE_GLOBAL_TRANSPARENCY equ $4B

; Memory slot 0 (8K), Read/Write
; Byte: Select the RAM page at locations $0000 to $1FFF (0-95, 96-223, 255)
; Note: Values between 96 and 223 are only available on a 2MB expanded Next.
;   Writing the value 255 will map the current ROM into this slot.
;   Defaults to 255 after a reset.
;   Writing to ports P16W_PLUS3_MEMORY_PAGING, P16W_MEMORY_PAGING and P16W_NX_NEXT_MEMORY_BANK overrides all NXRW_MEMORY_SLOT_x values.
;   Enabling P3MP_SPECIAL_PAGING_MODE in the P16W_PLUS3_MEMORY_PAGING port will disable all NXRW_MEMORY_SLOT_x values.
NXRW_MEMORY_SLOT_0 equ $50

; Memory slot 1 (8K), Read/Write
; Byte: Select the RAM page at locations $2000 to $3FFF (0-95, 96-223, 255)
; Note: Values between 96 and 223 are only available on a 2MB expanded Next.
;   Writing the value 255 will map the current ROM into this slot.
;   Defaults to 255 after a reset.
;   Writing to ports P16W_PLUS3_MEMORY_PAGING, P16W_MEMORY_PAGING and P16W_NX_NEXT_MEMORY_BANK overrides all NXRW_MEMORY_SLOT_x values.
;   Enabling P3MP_SPECIAL_PAGING_MODE in the P16W_PLUS3_MEMORY_PAGING port will disable all NXRW_MEMORY_SLOT_x values.
NXRW_MEMORY_SLOT_1 equ $51

; Memory slot 2 (8K), Read/Write
; Byte: Select the RAM page at locations $4000 to $5FFF (0-95, 96-223)
; Note: Values between 96 and 223 are only available on a 2MB expanded Next.
;   Defaults to 10 after a reset.
;   Writing to ports P16W_PLUS3_MEMORY_PAGING, P16W_MEMORY_PAGING and P16W_NX_NEXT_MEMORY_BANK overrides all NXRW_MEMORY_SLOT_x values.
;   Enabling P3MP_SPECIAL_PAGING_MODE in the P16W_PLUS3_MEMORY_PAGING port will disable all NXRW_MEMORY_SLOT_x values.
NXRW_MEMORY_SLOT_2 equ $52

; Memory slot 3 (8K), Read/Write
; Byte: Select the RAM page at locations $6000 to $7FFF (0-95, 96-223)
; Note: Values between 96 and 223 are only available on a 2MB expanded Next.
;   Defaults to 11 after a reset.
;   Writing to ports P16W_PLUS3_MEMORY_PAGING, P16W_MEMORY_PAGING and P16W_NX_NEXT_MEMORY_BANK overrides all NXRW_MEMORY_SLOT_x values.
;   Enabling P3MP_SPECIAL_PAGING_MODE in the P16W_PLUS3_MEMORY_PAGING port will disable all NXRW_MEMORY_SLOT_x values.
NXRW_MEMORY_SLOT_3 equ $53

; Memory slot 4 (8K), Read/Write
; Byte: Select the RAM page at locations $8000 to $9FFF (0-95, 96-223)
; Note: Values between 96 and 223 are only available on a 2MB expanded Next.
;   Defaults to 4 after a reset.
;   Writing to ports P16W_PLUS3_MEMORY_PAGING, P16W_MEMORY_PAGING and P16W_NX_NEXT_MEMORY_BANK overrides all NXRW_MEMORY_SLOT_x values.
;   Enabling P3MP_SPECIAL_PAGING_MODE in the P16W_PLUS3_MEMORY_PAGING port will disable all NXRW_MEMORY_SLOT_x values.
NXRW_MEMORY_SLOT_4 equ $54

; Memory slot 5 (8K), Read/Write
; Byte: Select the RAM page at locations $A000 to $BFFF (0-95, 96-223)
; Note: Values between 96 and 223 are only available on a 2MB expanded Next.
;   Defaults to 5 after a reset.
;   Writing to ports P16W_PLUS3_MEMORY_PAGING, P16W_MEMORY_PAGING and P16W_NX_NEXT_MEMORY_BANK overrides all NXRW_MEMORY_SLOT_x values.
;   Enabling P3MP_SPECIAL_PAGING_MODE in the P16W_PLUS3_MEMORY_PAGING port will disable all NXRW_MEMORY_SLOT_x values.
NXRW_MEMORY_SLOT_5 equ $55

; Memory slot 6 (8K), Read/Write
; Byte: Select the RAM page at locations $C000 to $DFFF (0-95, 96-223)
; Note: Values between 96 and 223 are only available on a 2MB expanded Next.
;   Defaults to 0 after a reset.
;   Writing to ports P16W_PLUS3_MEMORY_PAGING, P16W_MEMORY_PAGING and P16W_NX_NEXT_MEMORY_BANK overrides all NXRW_MEMORY_SLOT_x values.
;   Enabling P3MP_SPECIAL_PAGING_MODE in the P16W_PLUS3_MEMORY_PAGING port will disable all NXRW_MEMORY_SLOT_x values.
NXRW_MEMORY_SLOT_6 equ $56

; Memory slot 7 (8K), Read/Write
; Byte: Select the RAM page at locations $E000 to $FFFF (0-95, 96-223)
; Note: Values between 96 and 223 are only available on a 2MB expanded Next.
;   Defaults to 1 after a reset.
;   Writing to ports P16W_PLUS3_MEMORY_PAGING, P16W_MEMORY_PAGING and P16W_NX_NEXT_MEMORY_BANK overrides all NXRW_MEMORY_SLOT_x values.
;   Enabling P3MP_SPECIAL_PAGING_MODE in the P16W_PLUS3_MEMORY_PAGING port will disable all NXRW_MEMORY_SLOT_x values.
NXRW_MEMORY_SLOT_7 equ $57

; Copper data, Write
; Each copper instruction is 16 bits
; Write Byte 1: High byte of copper instruction
; Write Byte 2: Low byte of copper instruction
; Bit 15: 1 = WAIT instruction, 0 = MOVE instruction
; WAIT instruction:
;   Bits 0-8: Vertical raster line to wait for (0-311)
;   Bits 9-14: Horizontal position (0-55, every 8 pixels)
; MOVE instruction:
;   Bits 0-7: Value to write (0-255)
;   Bits 8-14: Next register to write (0-127)
; Note: After each second write, the index register NXW_COPPER_CONTROL_LOW_BYTE (and NXW_COPPER_CONTROL_HIGH_BYTE if required) is auto-incremented.
;   Horizontal positions are 0-55, every 8 pixels
;   Vertical positions are 0-311
;   Only Next Registers 0-127 can be written to
;   Writing to a READ ONLY register (like register $00) will act as a “NOP”, and this means you can wait for a low res horizontal value,
;     then output NOPs to get to a more precise location.
NXW_COPPER_DATA equ $60
CD_HI_MOVE equ                  %00000000
CD_HI_MOVE_NOP equ              %00000000
CD_LO_MOVE_NOP equ              %00000000
CD_HI_WAIT equ                  %10000000
CD_HI_WAIT_HORIZONTAL_MASK equ  %01111110
CD_HI_WAIT_HORIZONTAL_0 equ     %00000000
CD_HI_WAIT_HORIZONTAL_8 equ     %00000100
CD_HI_WAIT_HORIZONTAL_16 equ    %00000110
CD_HI_WAIT_HORIZONTAL_24 equ    %00000010
CD_HI_WAIT_HORIZONTAL_32 equ    %00001000
CD_HI_WAIT_HORIZONTAL_40 equ    %00001010
CD_HI_WAIT_HORIZONTAL_48 equ    %00001100
CD_HI_WAIT_HORIZONTAL_56 equ    %00001110
CD_HI_WAIT_HORIZONTAL_64 equ    %00010000
CD_HI_WAIT_HORIZONTAL_72 equ    %00010010
CD_HI_WAIT_HORIZONTAL_80 equ    %00010100
CD_HI_WAIT_HORIZONTAL_88 equ    %00010110
CD_HI_WAIT_HORIZONTAL_96 equ    %00011000
CD_HI_WAIT_HORIZONTAL_104 equ   %00011010
CD_HI_WAIT_HORIZONTAL_112 equ   %00011100
CD_HI_WAIT_HORIZONTAL_120 equ   %00011110
CD_HI_WAIT_HORIZONTAL_128 equ   %00100000
CD_HI_WAIT_HORIZONTAL_136 equ   %00100010
CD_HI_WAIT_HORIZONTAL_144 equ   %00100100
CD_HI_WAIT_HORIZONTAL_152 equ   %00100110
CD_HI_WAIT_HORIZONTAL_160 equ   %00101000
CD_HI_WAIT_HORIZONTAL_168 equ   %00101010
CD_HI_WAIT_HORIZONTAL_176 equ   %00101100
CD_HI_WAIT_HORIZONTAL_184 equ   %00101110
CD_HI_WAIT_HORIZONTAL_192 equ   %00110000
CD_HI_WAIT_HORIZONTAL_200 equ   %00110010
CD_HI_WAIT_HORIZONTAL_208 equ   %00110100
CD_HI_WAIT_HORIZONTAL_216 equ   %00110110
CD_HI_WAIT_HORIZONTAL_224 equ   %00111000
CD_HI_WAIT_HORIZONTAL_232 equ   %00111010
CD_HI_WAIT_HORIZONTAL_240 equ   %00111100
CD_HI_WAIT_HORIZONTAL_248 equ   %00111110
CD_HI_WAIT_HORIZONTAL_256 equ   %01000000
CD_HI_WAIT_HORIZONTAL_264 equ   %01000010
CD_HI_WAIT_HORIZONTAL_272 equ   %01000100
CD_HI_WAIT_HORIZONTAL_280 equ   %01000110
CD_HI_WAIT_HORIZONTAL_288 equ   %01001000
CD_HI_WAIT_HORIZONTAL_296 equ   %01001010
CD_HI_WAIT_HORIZONTAL_304 equ   %01001100
CD_HI_WAIT_HORIZONTAL_312 equ   %01001110
CD_HI_WAIT_HORIZONTAL_320 equ   %01010000
CD_HI_WAIT_HORIZONTAL_328 equ   %01010010
CD_HI_WAIT_HORIZONTAL_336 equ   %01010100
CD_HI_WAIT_HORIZONTAL_344 equ   %01010110
CD_HI_WAIT_HORIZONTAL_352 equ   %01011000
CD_HI_WAIT_HORIZONTAL_360 equ   %01011010
CD_HI_WAIT_HORIZONTAL_368 equ   %01011100
CD_HI_WAIT_HORIZONTAL_376 equ   %01011110
CD_HI_WAIT_HORIZONTAL_384 equ   %01100000
CD_HI_WAIT_HORIZONTAL_392 equ   %01100010
CD_HI_WAIT_HORIZONTAL_400 equ   %01100100
CD_HI_WAIT_HORIZONTAL_408 equ   %01100110
CD_HI_WAIT_HORIZONTAL_416 equ   %01101000
CD_HI_WAIT_HORIZONTAL_424 equ   %01101010
CD_HI_WAIT_HORIZONTAL_432 equ   %01101100
CD_HI_WAIT_HORIZONTAL_440 equ   %01101110
CD_HI_WAIT_VERTICAL_MASK equ    %00000001
CD_HI_WAIT_VERTICAL_ADD_0 equ   %00000000
CD_HI_WAIT_VERTICAL_ADD_256 equ %00000001
CD_HI_WAIT_FOREVER equ          %00000001
CD_LO_WAIT_VERTICAL_0 equ       %00000000
CD_LO_WAIT_VERTICAL_1 equ       %00000001
CD_LO_WAIT_VERTICAL_2 equ       %00000010
CD_LO_WAIT_VERTICAL_3 equ       %00000011
CD_LO_WAIT_VERTICAL_4 equ       %00000100
CD_LO_WAIT_VERTICAL_5 equ       %00000101
CD_LO_WAIT_VERTICAL_6 equ       %00000110
CD_LO_WAIT_VERTICAL_7 equ       %00000111
CD_LO_WAIT_VERTICAL_8 equ       %00001000
CD_LO_WAIT_VERTICAL_9 equ       %00001001
CD_LO_WAIT_VERTICAL_10 equ      %00001010
CD_LO_WAIT_VERTICAL_11 equ      %00001011
CD_LO_WAIT_VERTICAL_12 equ      %00001100
CD_LO_WAIT_VERTICAL_13 equ      %00001101
CD_LO_WAIT_VERTICAL_14 equ      %00001110
CD_LO_WAIT_VERTICAL_15 equ      %00001111
CD_LO_WAIT_VERTICAL_16 equ      %00010000
CD_LO_WAIT_VERTICAL_17 equ      %00010001
CD_LO_WAIT_VERTICAL_18 equ      %00010010
CD_LO_WAIT_VERTICAL_19 equ      %00010011
CD_LO_WAIT_VERTICAL_20 equ      %00010100
CD_LO_WAIT_VERTICAL_21 equ      %00010101
CD_LO_WAIT_VERTICAL_22 equ      %00010110
CD_LO_WAIT_VERTICAL_23 equ      %00010111
CD_LO_WAIT_VERTICAL_24 equ      %00011000
CD_LO_WAIT_VERTICAL_25 equ      %00011001
CD_LO_WAIT_VERTICAL_26 equ      %00011010
CD_LO_WAIT_VERTICAL_27 equ      %00011011
CD_LO_WAIT_VERTICAL_28 equ      %00011100
CD_LO_WAIT_VERTICAL_29 equ      %00011101
CD_LO_WAIT_VERTICAL_30 equ      %00011110
CD_LO_WAIT_VERTICAL_31 equ      %00011111
CD_LO_WAIT_VERTICAL_32 equ      %00100000
CD_LO_WAIT_VERTICAL_33 equ      %00100001
CD_LO_WAIT_VERTICAL_34 equ      %00100010
CD_LO_WAIT_VERTICAL_35 equ      %00100011
CD_LO_WAIT_VERTICAL_36 equ      %00100100
CD_LO_WAIT_VERTICAL_37 equ      %00100101
CD_LO_WAIT_VERTICAL_38 equ      %00100110
CD_LO_WAIT_VERTICAL_39 equ      %00100111
CD_LO_WAIT_VERTICAL_40 equ      %00101000
CD_LO_WAIT_VERTICAL_41 equ      %00101001
CD_LO_WAIT_VERTICAL_42 equ      %00101010
CD_LO_WAIT_VERTICAL_43 equ      %00101011
CD_LO_WAIT_VERTICAL_44 equ      %00101100
CD_LO_WAIT_VERTICAL_45 equ      %00101101
CD_LO_WAIT_VERTICAL_46 equ      %00101110
CD_LO_WAIT_VERTICAL_47 equ      %00101111
CD_LO_WAIT_VERTICAL_48 equ      %00110000
CD_LO_WAIT_VERTICAL_49 equ      %00110001
CD_LO_WAIT_VERTICAL_50 equ      %00110010
CD_LO_WAIT_VERTICAL_51 equ      %00110011
CD_LO_WAIT_VERTICAL_52 equ      %00110100
CD_LO_WAIT_VERTICAL_53 equ      %00110101
CD_LO_WAIT_VERTICAL_54 equ      %00110110
CD_LO_WAIT_VERTICAL_55 equ      %00110111
CD_LO_WAIT_VERTICAL_56 equ      %00111000
CD_LO_WAIT_VERTICAL_57 equ      %00111001
CD_LO_WAIT_VERTICAL_58 equ      %00111010
CD_LO_WAIT_VERTICAL_59 equ      %00111011
CD_LO_WAIT_VERTICAL_60 equ      %00111100
CD_LO_WAIT_VERTICAL_61 equ      %00111101
CD_LO_WAIT_VERTICAL_62 equ      %00111110
CD_LO_WAIT_VERTICAL_63 equ      %00111111
CD_LO_WAIT_VERTICAL_64 equ      %01000000
CD_LO_WAIT_VERTICAL_65 equ      %01000001
CD_LO_WAIT_VERTICAL_66 equ      %01000010
CD_LO_WAIT_VERTICAL_67 equ      %01000011
CD_LO_WAIT_VERTICAL_68 equ      %01000100
CD_LO_WAIT_VERTICAL_69 equ      %01000101
CD_LO_WAIT_VERTICAL_70 equ      %01000110
CD_LO_WAIT_VERTICAL_71 equ      %01000111
CD_LO_WAIT_VERTICAL_72 equ      %01001000
CD_LO_WAIT_VERTICAL_73 equ      %01001001
CD_LO_WAIT_VERTICAL_74 equ      %01001010
CD_LO_WAIT_VERTICAL_75 equ      %01001011
CD_LO_WAIT_VERTICAL_76 equ      %01001100
CD_LO_WAIT_VERTICAL_77 equ      %01001101
CD_LO_WAIT_VERTICAL_78 equ      %01001110
CD_LO_WAIT_VERTICAL_79 equ      %01001111
CD_LO_WAIT_VERTICAL_80 equ      %01010000
CD_LO_WAIT_VERTICAL_81 equ      %01010001
CD_LO_WAIT_VERTICAL_82 equ      %01010010
CD_LO_WAIT_VERTICAL_83 equ      %01010011
CD_LO_WAIT_VERTICAL_84 equ      %01010100
CD_LO_WAIT_VERTICAL_85 equ      %01010101
CD_LO_WAIT_VERTICAL_86 equ      %01010110
CD_LO_WAIT_VERTICAL_87 equ      %01010111
CD_LO_WAIT_VERTICAL_88 equ      %01011000
CD_LO_WAIT_VERTICAL_89 equ      %01011001
CD_LO_WAIT_VERTICAL_90 equ      %01011010
CD_LO_WAIT_VERTICAL_91 equ      %01011011
CD_LO_WAIT_VERTICAL_92 equ      %01011100
CD_LO_WAIT_VERTICAL_93 equ      %01011101
CD_LO_WAIT_VERTICAL_94 equ      %01011110
CD_LO_WAIT_VERTICAL_95 equ      %01011111
CD_LO_WAIT_VERTICAL_96 equ      %01100000
CD_LO_WAIT_VERTICAL_97 equ      %01100001
CD_LO_WAIT_VERTICAL_98 equ      %01100010
CD_LO_WAIT_VERTICAL_99 equ      %01100011
CD_LO_WAIT_VERTICAL_100 equ     %01100100
CD_LO_WAIT_VERTICAL_101 equ     %01100101
CD_LO_WAIT_VERTICAL_102 equ     %01100110
CD_LO_WAIT_VERTICAL_103 equ     %01100111
CD_LO_WAIT_VERTICAL_104 equ     %01101000
CD_LO_WAIT_VERTICAL_105 equ     %01101001
CD_LO_WAIT_VERTICAL_106 equ     %01101010
CD_LO_WAIT_VERTICAL_107 equ     %01101011
CD_LO_WAIT_VERTICAL_108 equ     %01101100
CD_LO_WAIT_VERTICAL_109 equ     %01101101
CD_LO_WAIT_VERTICAL_110 equ     %01101110
CD_LO_WAIT_VERTICAL_111 equ     %01101111
CD_LO_WAIT_VERTICAL_112 equ     %01110000
CD_LO_WAIT_VERTICAL_113 equ     %01110001
CD_LO_WAIT_VERTICAL_114 equ     %01110010
CD_LO_WAIT_VERTICAL_115 equ     %01110011
CD_LO_WAIT_VERTICAL_116 equ     %01110100
CD_LO_WAIT_VERTICAL_117 equ     %01110101
CD_LO_WAIT_VERTICAL_118 equ     %01110110
CD_LO_WAIT_VERTICAL_119 equ     %01110111
CD_LO_WAIT_VERTICAL_120 equ     %01111000
CD_LO_WAIT_VERTICAL_121 equ     %01111001
CD_LO_WAIT_VERTICAL_122 equ     %01111010
CD_LO_WAIT_VERTICAL_123 equ     %01111011
CD_LO_WAIT_VERTICAL_124 equ     %01111100
CD_LO_WAIT_VERTICAL_125 equ     %01111101
CD_LO_WAIT_VERTICAL_126 equ     %01111110
CD_LO_WAIT_VERTICAL_127 equ     %01111111
CD_LO_WAIT_VERTICAL_128 equ     %10000000
CD_LO_WAIT_VERTICAL_129 equ     %10000001
CD_LO_WAIT_VERTICAL_130 equ     %10000010
CD_LO_WAIT_VERTICAL_131 equ     %10000011
CD_LO_WAIT_VERTICAL_132 equ     %10000100
CD_LO_WAIT_VERTICAL_133 equ     %10000101
CD_LO_WAIT_VERTICAL_134 equ     %10000110
CD_LO_WAIT_VERTICAL_135 equ     %10000111
CD_LO_WAIT_VERTICAL_136 equ     %10001000
CD_LO_WAIT_VERTICAL_137 equ     %10001001
CD_LO_WAIT_VERTICAL_138 equ     %10001010
CD_LO_WAIT_VERTICAL_139 equ     %10001011
CD_LO_WAIT_VERTICAL_140 equ     %10001100
CD_LO_WAIT_VERTICAL_141 equ     %10001101
CD_LO_WAIT_VERTICAL_142 equ     %10001110
CD_LO_WAIT_VERTICAL_143 equ     %10001111
CD_LO_WAIT_VERTICAL_144 equ     %10010000
CD_LO_WAIT_VERTICAL_145 equ     %10010001
CD_LO_WAIT_VERTICAL_146 equ     %10010010
CD_LO_WAIT_VERTICAL_147 equ     %10010011
CD_LO_WAIT_VERTICAL_148 equ     %10010100
CD_LO_WAIT_VERTICAL_149 equ     %10010101
CD_LO_WAIT_VERTICAL_150 equ     %10010110
CD_LO_WAIT_VERTICAL_151 equ     %10010111
CD_LO_WAIT_VERTICAL_152 equ     %10011000
CD_LO_WAIT_VERTICAL_153 equ     %10011001
CD_LO_WAIT_VERTICAL_154 equ     %10011010
CD_LO_WAIT_VERTICAL_155 equ     %10011011
CD_LO_WAIT_VERTICAL_156 equ     %10011100
CD_LO_WAIT_VERTICAL_157 equ     %10011101
CD_LO_WAIT_VERTICAL_158 equ     %10011110
CD_LO_WAIT_VERTICAL_159 equ     %10011111
CD_LO_WAIT_VERTICAL_160 equ     %10100000
CD_LO_WAIT_VERTICAL_161 equ     %10100001
CD_LO_WAIT_VERTICAL_162 equ     %10100010
CD_LO_WAIT_VERTICAL_163 equ     %10100011
CD_LO_WAIT_VERTICAL_164 equ     %10100100
CD_LO_WAIT_VERTICAL_165 equ     %10100101
CD_LO_WAIT_VERTICAL_166 equ     %10100110
CD_LO_WAIT_VERTICAL_167 equ     %10100111
CD_LO_WAIT_VERTICAL_168 equ     %10101000
CD_LO_WAIT_VERTICAL_169 equ     %10101001
CD_LO_WAIT_VERTICAL_170 equ     %10101010
CD_LO_WAIT_VERTICAL_171 equ     %10101011
CD_LO_WAIT_VERTICAL_172 equ     %10101100
CD_LO_WAIT_VERTICAL_173 equ     %10101101
CD_LO_WAIT_VERTICAL_174 equ     %10101110
CD_LO_WAIT_VERTICAL_175 equ     %10101111
CD_LO_WAIT_VERTICAL_176 equ     %10110000
CD_LO_WAIT_VERTICAL_177 equ     %10110001
CD_LO_WAIT_VERTICAL_178 equ     %10110010
CD_LO_WAIT_VERTICAL_179 equ     %10110011
CD_LO_WAIT_VERTICAL_180 equ     %10110100
CD_LO_WAIT_VERTICAL_181 equ     %10110101
CD_LO_WAIT_VERTICAL_182 equ     %10110110
CD_LO_WAIT_VERTICAL_183 equ     %10110111
CD_LO_WAIT_VERTICAL_184 equ     %10111000
CD_LO_WAIT_VERTICAL_185 equ     %10111001
CD_LO_WAIT_VERTICAL_186 equ     %10111010
CD_LO_WAIT_VERTICAL_187 equ     %10111011
CD_LO_WAIT_VERTICAL_188 equ     %10111100
CD_LO_WAIT_VERTICAL_189 equ     %10111101
CD_LO_WAIT_VERTICAL_190 equ     %10111110
CD_LO_WAIT_VERTICAL_191 equ     %10111111
CD_LO_WAIT_VERTICAL_192 equ     %11000000
CD_LO_WAIT_VERTICAL_193 equ     %11000001
CD_LO_WAIT_VERTICAL_194 equ     %11000010
CD_LO_WAIT_VERTICAL_195 equ     %11000011
CD_LO_WAIT_VERTICAL_196 equ     %11000100
CD_LO_WAIT_VERTICAL_197 equ     %11000101
CD_LO_WAIT_VERTICAL_198 equ     %11000110
CD_LO_WAIT_VERTICAL_199 equ     %11000111
CD_LO_WAIT_VERTICAL_200 equ     %11001000
CD_LO_WAIT_VERTICAL_201 equ     %11001001
CD_LO_WAIT_VERTICAL_202 equ     %11001010
CD_LO_WAIT_VERTICAL_203 equ     %11001011
CD_LO_WAIT_VERTICAL_204 equ     %11001100
CD_LO_WAIT_VERTICAL_205 equ     %11001101
CD_LO_WAIT_VERTICAL_206 equ     %11001110
CD_LO_WAIT_VERTICAL_207 equ     %11001111
CD_LO_WAIT_VERTICAL_208 equ     %11010000
CD_LO_WAIT_VERTICAL_209 equ     %11010001
CD_LO_WAIT_VERTICAL_210 equ     %11010010
CD_LO_WAIT_VERTICAL_211 equ     %11010011
CD_LO_WAIT_VERTICAL_212 equ     %11010100
CD_LO_WAIT_VERTICAL_213 equ     %11010101
CD_LO_WAIT_VERTICAL_214 equ     %11010110
CD_LO_WAIT_VERTICAL_215 equ     %11010111
CD_LO_WAIT_VERTICAL_216 equ     %11011000
CD_LO_WAIT_VERTICAL_217 equ     %11011001
CD_LO_WAIT_VERTICAL_218 equ     %11011010
CD_LO_WAIT_VERTICAL_219 equ     %11011011
CD_LO_WAIT_VERTICAL_220 equ     %11011100
CD_LO_WAIT_VERTICAL_221 equ     %11011101
CD_LO_WAIT_VERTICAL_222 equ     %11011110
CD_LO_WAIT_VERTICAL_223 equ     %11011111
CD_LO_WAIT_VERTICAL_224 equ     %11100000
CD_LO_WAIT_VERTICAL_225 equ     %11100001
CD_LO_WAIT_VERTICAL_226 equ     %11100010
CD_LO_WAIT_VERTICAL_227 equ     %11100011
CD_LO_WAIT_VERTICAL_228 equ     %11100100
CD_LO_WAIT_VERTICAL_229 equ     %11100101
CD_LO_WAIT_VERTICAL_230 equ     %11100110
CD_LO_WAIT_VERTICAL_231 equ     %11100111
CD_LO_WAIT_VERTICAL_232 equ     %11101000
CD_LO_WAIT_VERTICAL_233 equ     %11101001
CD_LO_WAIT_VERTICAL_234 equ     %11101010
CD_LO_WAIT_VERTICAL_235 equ     %11101011
CD_LO_WAIT_VERTICAL_236 equ     %11101100
CD_LO_WAIT_VERTICAL_237 equ     %11101101
CD_LO_WAIT_VERTICAL_238 equ     %11101110
CD_LO_WAIT_VERTICAL_239 equ     %11101111
CD_LO_WAIT_VERTICAL_240 equ     %11110000
CD_LO_WAIT_VERTICAL_241 equ     %11110001
CD_LO_WAIT_VERTICAL_242 equ     %11110010
CD_LO_WAIT_VERTICAL_243 equ     %11110011
CD_LO_WAIT_VERTICAL_244 equ     %11110100
CD_LO_WAIT_VERTICAL_245 equ     %11110101
CD_LO_WAIT_VERTICAL_246 equ     %11110110
CD_LO_WAIT_VERTICAL_247 equ     %11110111
CD_LO_WAIT_VERTICAL_248 equ     %11111000
CD_LO_WAIT_VERTICAL_249 equ     %11111001
CD_LO_WAIT_VERTICAL_250 equ     %11111010
CD_LO_WAIT_VERTICAL_251 equ     %11111011
CD_LO_WAIT_VERTICAL_252 equ     %11111100
CD_LO_WAIT_VERTICAL_253 equ     %11111101
CD_LO_WAIT_VERTICAL_254 equ     %11111110
CD_LO_WAIT_VERTICAL_255 equ     %11111111
CD_LO_WAIT_FOREVER equ          %10010000
; There are no constants for the Move instructions as the two values are on a byte boundry, so can be set directly

; Copper control low byte, Write
; Write Byte: Least Significant Byte of the copper list index to modify with the NXW_COPPER_DATA register (0-255)
NXW_COPPER_CONTROL_LOW_BYTE equ $61

; Copper control high byte, Write
; Write Bits 0-1: 2 Most Significant Bits of the copper list index to modify with the NXW_COPPER_DATA register.
; Write Bits 2-5: Reserved, always set to 0
; Write Bits 6-7: Start control;
;   00 = Copper fully stopped
;   01 = Copper start, execute the list, then stop at the last address
;   10 = Copper start, execute the list, then loop the list from the start
;   11 = Copper start, execute the list and restart the list at each frame
NXW_COPPER_CONTROL_HIGH_BYTE equ $62
CCHB_INDEX_ADDRESS_MASK equ          %00000011
CCHB_INDEX_ADDRESS_ADD_0 equ         %00000000
CCHB_INDEX_ADDRESS_ADD_256 equ       %00000001
CCHB_INDEX_ADDRESS_ADD_512 equ       %00000010
CCHB_INDEX_ADDRESS_ADD_768 equ       %00000011
CCHB_START_CONTROL_MASK equ          %11000000
CCHB_START_CONTROL_STOPPED equ       %00000000
CCHB_START_CONTROL_STOP_LAST equ     %01000000
CCHB_START_CONTROL_LOOP equ          %10000000
CCHB_START_CONTROL_RESTART_FRAME equ %11000000

; Debug LED control, Write
; Only used on DE-1, DE-2 and Multicore boards
NXW_DEBUG_LED_CONTROL equ $FF
