; Standard ZX Spectrum defines
; EQU format
; V1.0
; Written by David Powell
; This file is released into the public domain


; *** ZX Spectrum 8-bit ports, the upper byte is ignored ***

; ULA, Read/Write
; Write Bits 0-2: Border colour in G1R1B1 format
; Write Bit 3: 1 = Disable MIC output, 0 = Enable MIC output
; Write Bit 4: 1 = Enable EAR & speaker output, 0 = Disable EAR & speaker output
; Read Bit 6: 1 = EAR input level high, 0 = EAR input level low
; Note: Reading keys requires a 16-bit port read, detailed below
P8RW_ULA equ $FE
ULA_BORDER_MASK equ    %00000111
ULA_BORDER_BLACK equ   %00000000
ULA_BORDER_BLUE equ    %00000001
ULA_BORDER_RED equ     %00000010
ULA_BORDER_MAGENTA equ %00000011
ULA_BORDER_GREEN equ   %00000100
ULA_BORDER_CYAN equ    %00000101
ULA_BORDER_YELLOW equ  %00000110
ULA_BORDER_WHITE equ   %00000111
ULA_NOT_MIC_OUTPUT equ %00001000
ULA_EAR_OUTPUT equ     %00010000
ULA_EAR_INPUT equ      %01000000

; Z8410 DMA chip on MB02 port, Read/Write
; Byte: A sequence of control bytes
P8RW_DMA_MB02 equ $0B

; Z8410 DMA chip on Data-Gear port, Read/Write
; Note: Same as P8RW_DMA_MB02, but on a different port number
P8RW_DMA_DATAGEAR equ $6B

; Kempston joystick state, Read
; Read Bit 0: 1 = Right, 0 = Not right
; Read Bit 1: 1 = Left, 0 = Not left
; Read Bit 2: 1 = Down, 0 = Not down
; Read Bit 3: 1 = Up, 0 = Not up
; Read Bit 4: 1 = Fire, 0 = Not fire
P8R_KEMPSTON_JOYSTICK equ $1F
KJ_RIGHT equ %00000001
KJ_LEFT equ  %00000010
KJ_DOWN equ  %00000100
KJ_UP equ    %00001000
KJ_FIRE equ  %00010000

; Cheetah SpecDrum, Write
; Write Byte: Unsigned sample data ($80 = silence)
P8W_SPECDRUM_DAC equ $DF

; Timex Sinclair 2068 memory bank select, Read/Write
; Bit 0: 1 = Use EX-ROM or DOCK bank 0, 0 = Use HOME bank 0; for addresses $0000-$1FFF 
; Bit 1: 1 = Use EX-ROM or DOCK bank 1, 0 = Use HOME bank 1; for addresses $2000-$3FFF 
; Bit 2: 1 = Use EX-ROM or DOCK bank 2, 0 = Use HOME bank 2; for addresses $4000-$5FFF 
; Bit 3: 1 = Use EX-ROM or DOCK bank 3, 0 = Use HOME bank 3; for addresses $6000-$7FFF 
; Bit 4: 1 = Use EX-ROM or DOCK bank 4, 0 = Use HOME bank 4; for addresses $8000-$9FFF 
; Bit 5: 1 = Use EX-ROM or DOCK bank 5, 0 = Use HOME bank 5; for addresses $A000-$BFFF 
; Bit 6: 1 = Use EX-ROM or DOCK bank 6, 0 = Use HOME bank 6; for addresses $C000-$DFFF 
; Bit 7: 1 = Use EX-ROM or DOCK bank 7, 0 = Use HOME bank 7; for addresses $E000-$FFFF 
; Note: The use of EX-ROM or DOCK banks is specified by the TMS_USE_EX_ROM_BANK bit in the P8RW_TIMEX_SCREEN_MODE port.
;   Either the EX-ROM banks or the DOCK banks, not both, can be paged in alongside the HOME memory.
P8RW_TIMEX_MEMORY_SELECT equ $F4
TMS_NOT_HOME_BANK_0 equ %00000001
TMS_NOT_HOME_BANK_1 equ %00000010
TMS_NOT_HOME_BANK_2 equ %00000100
TMS_NOT_HOME_BANK_3 equ %00001000
TMS_NOT_HOME_BANK_4 equ %00010000
TMS_NOT_HOME_BANK_5 equ %00100000
TMS_NOT_HOME_BANK_6 equ %01000000
TMS_NOT_HOME_BANK_7 equ %10000000

; Timex Sinclair 2068 screen mode select, Read/Write
; Bits 0-2: Screen mode;
;   000 = Standard screen 0 ($4000)
;   001 = Standard screen 1 ($6000)
;   010 = Hi-colour (8 x 1 attributes)
;   110 = Hi-resolution (512 x 192 pixels, monochrome)
; Bits 3-5: Screen colour in hi-resolution mode;
;   000 = Black on white
;   001 = Blue on yellow
;   010 = Red on cyan
;   011 = Magenta on green
;   100 = Green on magenta
;   101 = Cyan on red
;   110 = Yellow on blue
;   111 = White on black
; Bit 6: 1 = Disable ULA interrupt, 0 = Enable ULA interrupt
; Bit 7: 1 = Use EX-ROM horizontal MMU bank, 0 = Use DOCK horizontal MMU bank
P8RW_TIMEX_SCREEN_MODE equ $FF
TSM_MODE_MASK equ               %00000111
TSM_MODE_SCREEN_0 equ           %00000000
TSM_MODE_SCREEN_1 equ           %00000001
TSM_MODE_HICOLOUR equ           %00000010
TSM_MODE_HIRES equ              %00000110
TSM_COLOUR_MASK equ             %00111000
TSM_COLOUR_BLACK_ON_WHITE equ   %00000000
TSM_COLOUR_BLUE_ON_YELLOW equ   %00001000
TSM_COLOUR_RED_ON_CYAN equ      %00010000
TSM_COLOUR_MAGENTA_ON_GREEN equ %00011000
TSM_COLOUR_GREEN_ON_MAGENTA equ %00100000
TMS_COLOUR_CYAN_ON_RED equ      %00101000
TMS_COLOUR_YELLOW_ON_BLUE equ   %00110000
TMS_COLOUR_WHITE_ON_BLACK equ   %00111000
TMS_DISABLE_ULA_INTERRUPT equ   %01000000
TMS_USE_EX_ROM_BANK equ         %10000000

; Timex Sinclair 2068 AY-3-8910 sound register select, Write
; Write Byte: Select the AY register that will be accessed by the P8RW_TIMEX_AY_REGISTER_VALUE port (0-15)
P8W_TIMEX_AY_REGISTER_SELECT equ $F5

; Timex Sinclair 2068 AY-3-8910 sound register value, Read/Write
; Byte: The value of the AY register specified in the P8W_TIMEX_AY_REGISTER_SELECT port (0-255)
P8RW_TIMEX_AY_REGISTER_VALUE equ $F6

; Fuller Box Games Unit AY-3-8912 sound register select, Write
; Write Byte: Select the AY register that will be accessed by the P8RW_FULLER_AY_REGISTER_VALUE port (0-15)
P8W_FULLER_AY_REGISTER_SELECT equ $3F

; Fuller Box Games Unit AY-3-8912 sound register value, Read/Write
; Byte: The value of the AY register specified in the P8W_FULLER_AY_REGISTER_SELECT port (0-255)
P8RW_FULLER_AY_REGISTER_VALUE equ $5F

; Fuller Box Games Unit joystick state, Read
; Read Bit 0: 1 = Not up, 0 = Up
; Read Bit 1: 1 = Not down, 0 = Down
; Read Bit 2: 1 = Not left, 0 = Left
; Read Bit 3: 1 = Not right, 0 = Right
; Read Bit 7: 1 = Not fire, 0 = Fire
P8R_FULLER_JOYSTICK equ $7F
FJ_NOT_UP equ    %00000001
FJ_NOT_DOWN equ  %00000010
FJ_NOT_LEFT equ  %00000100
FJ_NOT_RIGHT equ %00001000
FJ_NOT_FIRE equ  %10000000

; Fuller Orator SP0256-AL2 speech chip, Write
; Write Bits 0-5: Allophone number
; Write Bits 6-7: Unknown
P8W_FULLER_ORATOR_OUTPUT equ $9F
FOO_ALLOPHONE_MASK equ %00111111

; Fuller Orator SP0256-AL2 speech chip status, Read
; Read Bits 0-6: Unknown
; Read Bit 7: Load Request (LRQ); 1 = Ready to receive data, 0 = Buffer full
P8R_FULLER_ORATOR_STATUS equ $BF
FOS_READY equ %10000000

; AERCO Centronics printer interface, Read/Write
; TODO: Documentation
P8RW_AERCO_CENTRONICS equ $7F

; Sinclair Interface 1 RS232
; TODO: Documentation
P8_INTERFACE1_RS232 equ $F7

; Sinclair Interface 1 Control
; TODO: Documentation
P8_INTERFACE1_CONTROL equ $EF

; Sinclair Interface 1 Microdrive
; TODO: Documentation
P8_INTERFACE1_MICRODRIVE equ $E7

; Sinclair ZX Printer
; TODO: Documentation
P8_ZX_PRINTER equ $FB

; Multiface 1 Input, Read
; TODO: Documentation
P8R_MULTIFACE1_IN equ $9F

; Multiface 1 Output, Write
; TODO: Documentation
P8W_MULTIFACE1_OUT equ $1F

; Multiface 128 Input, Read
; TODO: Documentation
P8R_MULTIFACE128_IN equ $BF

; Multiface 128 Input V2, Read
; TODO: Documentation
P8R_MULTIFACE128_IN_V2 equ $9F

; Multiface 128 Output, Write
; TODO: Documentation
P8W_MULTIFACE128_OUT equ $3F

; Multiface 3 Input, Read
; TODO: Documentation
P8R_MULTIFACE3_IN equ $3F

; Multiface 3 Output, Write
; TODO: Documentation
P8W_MULTIFACE3_OUT equ $BF

; Multiface 3 Button, Read
; TODO: Documentation
P8R_MULTIFACE3_BUTTON equ $3F

; ZX Lprint 3 enable, Write
; TODO: Documentation
P8W_LPRINT3_ON equ $FB

; ZX Lprint 3 disable, Write
; TODO: Documentation
P8W_LPRINT3_OFF equ $7B

; TR-DOS Technology Research Ltd. Beta Disc control
; TODO: Documentation
P8_TRDOS_COMMAND equ $1F
P8_TRDOS_STATE equ   $1F
P8_TRDOS_TRACK equ   $3F
P8_TRDOS_SECTOR equ  $5F
P8_TRDOS_DATA equ    $7F
P8_TRDOS_SYSTEM equ  $FF

; MGT Plus D disk drive control
; TODO: Documentation
P8_PLUSD_COMMAND equ $E3
P8_PLUSD_STATE equ   $E3
P8_PLUSD_PAGE equ    $E7
P8_PLUSD_TRACK equ   $EB
P8_PLUSD_SYSTEM equ  $EF
P8_PLUSD_SECTOR equ  $F3
P8_PLUSD_PRINTER equ $F7
P8_PLUSD_DATA equ    $FB

; Didaktik D80 disk drive control
; TODO: Documentation
P8_D80_COMMAND equ $81
P8_D80_STATE equ   $81
P8_D80_TRACK equ   $83
P8_D80_SECTOR equ  $85
P8_D80_DATA equ    $87
P8_D80_SYSTEM equ  $89

; JLO (Oliger) disk interface control
; TODO: Documentation
P8_JLO_COMMAND equ $47
P8_JLO_STATUS equ  $47
P8_JLO_TRACK equ   $9F
P8_JLO_SECTOR equ  $AF
P8_JLO_DATA equ    $BF
P8_JLO_SELECT equ  $B7


; *** ZX Spectrum 16-bit ports ***

; ULA keys B, N, M, Symbol Shift and Space state, Read
; Read Bit 0: 1 = Space not pressed, 0 = Space pressed
; Read Bit 1: 1 = Symbol Shift not pressed, 0 = Symbol Shift pressed
; Read Bit 2: 1 = M not pressed, 0 = M pressed
; Read Bit 3: 1 = N not pressed, 0 = N pressed
; Read Bit 4: 1 = B not pressed, 0 = B pressed
; Read Bit 6: 1 = EAR input level high, 0 = EAR input level low
P16R_ULA_KEYS_BNMSymSpc equ $7FFE
ULA_NOT_KEY_SPACE equ        %00000001
ULA_NOT_KEY_SYMBOL_SHIFT equ %00000010
ULA_NOT_KEY_M equ            %00000100
ULA_NOT_KEY_N equ            %00001000
ULA_NOT_KEY_B equ            %00010000

; ULA keys H, K, J, L and Enter state, Read
; Read Bit 0: 1 = Enter not pressed, 0 = Enter pressed
; Read Bit 1: 1 = L not pressed, 0 = L pressed
; Read Bit 2: 1 = J not pressed, 0 = J pressed
; Read Bit 3: 1 = K not pressed, 0 = K pressed
; Read Bit 4: 1 = H not pressed, 0 = H pressed
; Read Bit 6: 1 = EAR input level high, 0 = EAR input level low
P16R_ULA_KEYS_HKJLEnt equ $BFFE
ULA_NOT_KEY_ENTER equ %00000001
ULA_NOT_KEY_L equ     %00000010
ULA_NOT_KEY_J equ     %00000100
ULA_NOT_KEY_K equ     %00001000
ULA_NOT_KEY_H equ     %00010000

; ULA keys Y, U, I, O and P state, Read
; Read Bit 0: 1 = P not pressed, 0 = P pressed
; Read Bit 1: 1 = O not pressed, 0 = O pressed
; Read Bit 2: 1 = I not pressed, 0 = I pressed
; Read Bit 3: 1 = U not pressed, 0 = U pressed
; Read Bit 4: 1 = Y not pressed, 0 = Y pressed
; Read Bit 6: 1 = EAR input level high, 0 = EAR input level low
P16R_ULA_KEYS_YUIOP equ $DFFE
ULA_NOT_KEY_P equ %00000001
ULA_NOT_KEY_O equ %00000010
ULA_NOT_KEY_I equ %00000100
ULA_NOT_KEY_U equ %00001000
ULA_NOT_KEY_Y equ %00010000

; ULA keys 6, 7, 8, 9 and 0 state, Read
; Read Bit 0: 1 = 0 not pressed, 0 = 0 pressed
; Read Bit 1: 1 = 9 not pressed, 0 = 9 pressed
; Read Bit 2: 1 = 8 not pressed, 0 = 8 pressed
; Read Bit 3: 1 = 7 not pressed, 0 = 7 pressed
; Read Bit 4: 1 = 6 not pressed, 0 = 6 pressed
; Read Bit 6: 1 = EAR input level high, 0 = EAR input level low
P16R_ULA_KEYS_67890 equ $EFFE
ULA_NOT_KEY_0 equ %00000001
ULA_NOT_KEY_9 equ %00000010
ULA_NOT_KEY_8 equ %00000100
ULA_NOT_KEY_7 equ %00001000
ULA_NOT_KEY_6 equ %00010000

; ULA keys 5, 4, 3, 2 and 1 state, Read
; Read Bit 0: 1 = 1 not pressed, 0 = 1 pressed
; Read Bit 1: 1 = 2 not pressed, 0 = 2 pressed
; Read Bit 2: 1 = 3 not pressed, 0 = 3 pressed
; Read Bit 3: 1 = 4 not pressed, 0 = 4 pressed
; Read Bit 4: 1 = 5 not pressed, 0 = 5 pressed
; Read Bit 6: 1 = EAR input level high, 0 = EAR input level low
P16R_ULA_KEYS_54321 equ $F7FE
ULA_NOT_KEY_1 equ %00000001
ULA_NOT_KEY_2 equ %00000010
ULA_NOT_KEY_3 equ %00000100
ULA_NOT_KEY_4 equ %00001000
ULA_NOT_KEY_5 equ %00010000

; ULA keys T, R, E, W and Q state, Read
; Read Bit 0: 1 = Q not pressed, 0 = Q pressed
; Read Bit 1: 1 = W not pressed, 0 = W pressed
; Read Bit 2: 1 = E not pressed, 0 = E pressed
; Read Bit 3: 1 = R not pressed, 0 = R pressed
; Read Bit 4: 1 = T not pressed, 0 = T pressed
; Read Bit 6: 1 = EAR input level high, 0 = EAR input level low
P16R_ULA_KEYS_TREWQ equ $FBFE
ULA_NOT_KEY_Q equ %00000001
ULA_NOT_KEY_W equ %00000010
ULA_NOT_KEY_E equ %00000100
ULA_NOT_KEY_R equ %00001000
ULA_NOT_KEY_T equ %00010000

; ULA keys G, F, D, S and A state, Read
; Read Bit 0: 1 = A not pressed, 0 = A pressed
; Read Bit 1: 1 = S not pressed, 0 = S pressed
; Read Bit 2: 1 = D not pressed, 0 = D pressed
; Read Bit 3: 1 = F not pressed, 0 = F pressed
; Read Bit 4: 1 = G not pressed, 0 = G pressed
; Read Bit 6: 1 = EAR input level high, 0 = EAR input level low
P16R_ULA_KEYS_GFDSA equ $FDFE
ULA_NOT_KEY_A equ %00000001
ULA_NOT_KEY_S equ %00000010
ULA_NOT_KEY_D equ %00000100
ULA_NOT_KEY_F equ %00001000
ULA_NOT_KEY_G equ %00010000

; ULA keys V, C, X, Z and Caps Shift state, Read
; Read Bit 0: 1 = Caps Shift not pressed, 0 = Caps Shift pressed
; Read Bit 1: 1 = Z not pressed, 0 = Z pressed
; Read Bit 2: 1 = X not pressed, 0 = X pressed
; Read Bit 3: 1 = C not pressed, 0 = C pressed
; Read Bit 4: 1 = V not pressed, 0 = V pressed
; Read Bit 6: 1 = EAR input level high, 0 = EAR input level low
P16R_ULA_KEYS_VCXZCaps equ $FEFE
ULA_NOT_KEY_CAPS_SHIFT equ %00000001
ULA_NOT_KEY_Z equ          %00000010
ULA_NOT_KEY_X equ          %00000100
ULA_NOT_KEY_C equ          %00001000
ULA_NOT_KEY_V equ          %00010000

; ZX Spectrum 128K memory paging, Write
; Write Bits 0-2: Page in 16K RAM bank (0-7) at $C000
; Write Bit 3: 1 = Display shadow screen (bank 7), 0 = Display normal screen (bank 5)
; Write Bit 4: 1 = Page in 48K BASIC ROM at $0000, 0 = Page in 128K BASIC ROM at $0000
; Write Bit 5: 1 = Disable memory paging and further use of this port until reset
; Note: On +2A/+3 Bit 4 is the low bit of the 2-bit ROM selection
; Note: On Spectrum Next Bits 0-2 are the 3 LSBs of the 16K Bank number, the 3 MSBs are specified
;   in the lower 3 bits of the P16W_NX_MEMORY_BANK port.
P16W_MEMORY_PAGING equ $7FFD
MP_BANK_MASK equ     %00000111
MP_BANK_0 equ        %00000000
MP_BANK_1 equ        %00000001
MP_BANK_2 equ        %00000010
MP_BANK_3 equ        %00000011
MP_BANK_4 equ        %00000100
MP_BANK_5 equ        %00000101
MP_BANK_6 equ        %00000110
MP_BANK_7 equ        %00000111
MP_SHADOW_SCREEN equ %00001000
MP_48K_ROM equ       %00010000
MP_ROM_LSB equ       %00010000
MP_DISABLE equ       %00100000

; ZX Spectrum +2A/+3 additional memory paging, Write
; Write Bit 0: 1 = Special +2A/+3 paging mode (AllRam mode), 0 = Normal 128K/+2 paging mode
; Write Bit 1: In normal mode, ignored
; Write Bit 2: In normal mode, high bit of the 2-bit ROM selection;
;              ROM 00 = 128K editor and menu
;              ROM 01 = 128K syntax checker
;              ROM 10 = +3 DOS
;              ROM 11 = 48K BASIC
; Write Bit 3: 1 = Enable +3 disk motor, 0 = Disable +3 disk motor
; Write Bit 4: Printer port strobe (active low)
; Write Bits 1-2: In special mode;
;         Bit 2 =0    Bit 2 =0    Bit 2 =1    Bit 2 =1
;         Bit 1 =0    Bit 1 =1    Bit 1 =0    Bit 1 =1
; 0xffff +--------+  +--------+  +--------+  +--------+
;        | Bank 3 |  | Bank 7 |  | Bank 3 |  | Bank 3 |
;        |        |  | screen |  |        |  |        |
; 0xc000 +--------+  +--------+  +--------+  +--------+
;        | Bank 2 |  | Bank 6 |  | Bank 6 |  | Bank 6 |
;        |        |  |        |  |        |  |        |
; 0x8000 +--------+  +--------+  +--------+  +--------+
;        | Bank 1 |  | Bank 5 |  | Bank 5 |  | Bank 7 |
;        |        |  | screen |  | screen |  | screen |
; 0x4000 +--------+  +--------+  +--------+  +--------+
;        | Bank 0 |  | Bank 4 |  | Bank 4 |  | Bank 4 |
;        |        |  |        |  |        |  |        |
; 0x0000 +--------+  +--------+  +--------+  +--------+
P16W_PLUS3_MEMORY_PAGING equ $1FFD
P3MP_SPECIAL_PAGING_MODE equ   %00000001
P3MP_NORMAL_ROM_MSB equ        %00000100
P3MP_DISK_MOTOR equ            %00001000
P3MP_NOT_PRINTER_STROBE equ    %00010000
P3MP_SPECIAL_RAM_BANK_MASK equ %00000110
P3MP_SPECIAL_RAM_BANK_0 equ    %00000000
P3MP_SPECIAL_RAM_BANK_1 equ    %00000010
P3MP_SPECIAL_RAM_BANK_2 equ    %00000100
P3MP_SPECIAL_RAM_BANK_3 equ    %00000110

; ZX Spectrum 128K/+2/+2A/+3 AY-3-8912 sound register select, Write
; Write Byte: Select the AY register that will be accessed by the P16RW_AY_REGISTER_VALUE port (0-15)
P16W_AY_REGISTER_SELECT equ $FFFD

; ZX Spectrum 128K/+2/+2A/+3 AY-3-8912 sound register value, Read/Write
; Byte: The value of the AY register specified in the P16W_AY_REGISTER_SELECT port (0-255)
P16RW_AY_REGISTER_VALUE equ $BFFD

; Kempston Mouse button state, Read
; Read Bit 0: 1 = Right button not pressed, 0 = Right button pressed
; Read Bit 1: 1 = Left button not pressed, 0 = Left button pressed
P16R_KEMPSTON_MOUSE_BUTTONS equ $FADF
KMB_NOT_RIGHT_BUTTON equ %00000001
KMB_NOT_LEFT_BUTTON equ  %00000010

; Kempston Mouse X distance, Read
; Note: Value is between 0-255 and loops, it is not the screen position
P16R_KEMPSTON_MOUSE_X equ $FDDF

; Kempston Mouse Y distance, Read
; Note: Value is between 0-255 and loops, it is not the screen position
P16R_KEMPSTON_MOUSE_Y equ $FFDF

; ZX Spectrum +3 disk drive data, Read/Write
; TODO: Documentation
P16RW_PLUS3_FDC_DATA equ $3FFD

; ZX Spectrum +3 disk drive status, Read
; Read Bit 0: ACTA; Drive A; 1 = Positioning mode active, 0 = Positioning mode not active
; Read Bit 1: ACTB; Drive B; 1 = Positioning mode active, 0 = Positioning mode not active
; Read Bit 2: ACTC; Drive C; 1 = Positioning mode active, 0 = Positioning mode not active
; Read Bit 3: ACTD; Drive D; 1 = Positioning mode active, 0 = Positioning mode not active
; Read Bit 4: BUSY; Instruction (Device Busy); 1 = Active, 0 = Not active
; Read Bit 5: NDMA; 1 = Not in DMA mode, 0 = In DMA mode
; Read Bit 6: DIO; Data input/output; 1 = controller -> CPU?, 0 = CPU -> controller?
; Read Bit 7: MRQ; Main request; 1 = Data register ready, 0 = Data register not ready
; Note: Reading this port will return the main status register of the uPD764A chip
P16R_PLUS3_FDC_STATUS equ $2FFD
P3FS_ACTA equ %00000001
P3FS_ACTB equ %00000010
P3FS_ACTC equ %00000100
P3FS_ACTD equ %00001000
P3FS_BUSY equ %00010000
P3FS_NDMA equ %00100000
P3FS_DIO  equ %01000000
P3FS_MRQ  equ %10000000

; ZX Spectrum +3 Centronics printer interface, Read/Write
; TODO: Documentation
P16RW_PLUS3_CENTRONICS equ $0FFD

; British Micro GRAFPAD pen up/down
; TODO: Documentation
P16R_GRAFPAD_PEN equ $FF3F

; British Micro GRAFPAD X position
; TODO: Documentation
P16R_GRAFPAD_X equ $FFBF

; British Micro GRAFPAD Y position
; TODO: Documentation
P16R_GRAFPAD_Y equ $FF7F

; Sinclair Interface 2 joystick port 1, Read
; Read Bit 0: 1 = Fire not pressed, 0 = Fire pressed
; Read Bit 1: 1 = Up not pressed, 0 = Up pressed
; Read Bit 2: 1 = Down not pressed, 0 = Down pressed
; Read Bit 3: 1 = Right not pressed, 0 = Right pressed
; Read Bit 4: 1 = Left not pressed, 0 = Left pressed
; Note: This is the same as P16R_ULA_KEYS_67890 as the joystick is mapped to the keyboard
P16R_SINCLAIR_JOYSTICK_1 equ $EFFE
SJ1_NOT_FIRE equ  %00000001
SJ1_NOT_UP equ    %00000010
SJ1_NOT_DOWN equ  %00000100
SJ1_NOT_RIGHT equ %00001000
SJ1_NOT_LEFT equ  %00010000

; Sinclair Interface 2 joystick port 2, Read
; Read Bit 0: 1 = Left not pressed, 0 = Left pressed
; Read Bit 1: 1 = Right not pressed, 0 = Right pressed
; Read Bit 2: 1 = Down not pressed, 0 = Down pressed
; Read Bit 3: 1 = Up not pressed, 0 = Up pressed
; Read Bit 4: 1 = Fire not pressed, 0 = Fire pressed
; Note: This is the same as P16R_ULA_KEYS_54321 as the joystick is mapped to the keyboard
P16R_SINCLAIR_JOYSTICK_2 equ $F7FE
SJ2_NOT_LEFT equ  %00000001
SJ2_NOT_RIGHT equ %00000010
SJ2_NOT_DOWN equ  %00000100
SJ2_NOT_UP equ    %00001000
SJ2_NOT_FIRE equ  %00010000

; Multiface 3
; TODO: Documentation
P16_MULTIFACE3_P7FFD equ $7F3F
P16_MULTIFACE3_P1FFD equ $1F3F


; *** ZX Spectrum Memory Locations ***

; Screen bitmap and attributes
M_SCREEN_BITMAP_START equ     $4000
M_SCREEN_BITMAP_END equ       $57FF
M_SCREEN_BITMAP_SIZE equ      $1800
M_SCREEN_ATTRIBUTES_START equ $5800
M_SCREEN_ATTIBUTES_END equ    $5AFF
M_SCREEN_ATTRIBUTES_SIZE equ  $300

; 128K ZX Spectrum shadow screen bitmap and attributes
; Note: Bank 7 will need to be paged in as it contains the shadow screen
M_128K_SHADOW_SCREEN_BITMAP_START equ     $C000
M_128K_SHADOW_SCREEN_BITMAP_END equ       $D7FF
M_128K_SHADOW_SCREEN_BITMAP_SIZE equ      $1800
M_128K_SHADOW_SCREEN_ATTRIBUTES_START equ $D800
M_128K_SHADOW_SCREEN_ATTRIBUTES_END equ   $DAFF
M_128K_SHADOW_SCREEN_ATTRIBUTES_SIZE equ  $300

; Timex Sinclair 2068 screen 0 bitmap and attributes
; Note: Same as standard ZX Spectrum screen bitmap and attributes
M_TIMEX_SCREEN_0_BITMAP_START equ     $4000
M_TIMEX_SCREEN_0_BITMAP_END equ       $57FF
M_TIMEX_SCREEN_0_BITMAP_SIZE equ      $1800
M_TIMEX_SCREEN_0_ATTRIBUTES_START equ $5800
M_TIMEX_SCREEN_0_ATTRIBUTES_END equ   $DAFF
M_TIMEX_SCREEN_0_ATTRIBUTES_SIZE equ  $300

; Timex Sinclair 2068 screen 1 bitmap and attributes
M_TIMEX_SCREEN_1_BITMAP_START equ     $6000
M_TIMEX_SCREEN_1_BITMAP_END equ       $77FF
M_TIMEX_SCREEN_1_BITMAP_SIZE equ      $1800
M_TIMEX_SCREEN_1_ATTRIBUTES_START equ $7800
M_TIMEX_SCREEN_1_ATTRIBUTES_END equ   $7AFF
M_TIMEX_SCREEN_1_ATTRIBUTES_SIZE equ  $300

; Timex Sinclair 2068 Hi-Colour screen bitmap and attributes
M_TIMEX_SCREEN_HICOLOUR_BITMAP_START equ     $4000
M_TIMEX_SCREEN_HICOLOUR_BITMAP_END equ       $57FF
M_TIMEX_SCREEN_HICOLOUR_BITMAP_SIZE equ      $1800
M_TIMEX_SCREEN_HICOLOUR_ATTRIBUTES_START equ $6000
M_TIMEX_SCREEN_HICOLOUR_ATTRIBUTES_END equ   $77FF
M_TIMEX_SCREEN_HICOLOUR_ATTRIBUTES_SIZE equ  $1800

; Timex Sinclair 2068 Hi-Resolution screen bitmap
M_TIMEX_SCREEN_HIRES_BITMAP_COLUMN_ODD_START equ  $4000
M_TIMEX_SCREEN_HIRES_BITMAP_COLUMN_ODD_END equ    $57FF
M_TIMEX_SCREEN_HIRES_BITMAP_COLUMN_ODD_SIZE equ   $1800
M_TIMEX_SCREEN_HIRED_BITMAP_COLUMN_EVEN_START equ $6000
M_TIMEX_SCREEN_HIRED_BITMAP_COLUMN_EVEN_END equ   $77FF
M_TIMEX_SCREEN_HIRED_BITMAP_COLUMN_EVEN_SIZE equ  $1800
