; DMA Transfer routines
; EQU format
; V1.0
; Written by David Powell
; Based on code by Mike Dailly
; This file is released into the public domain


; Copy a block of memory from one place to another using DMA
; In: (DMA_Source) = Source address (16-bit word)
; In: (DMA_Length) = Number of bytes - 1, minimum 2 bytes as setting 1 will copy 2 bytes (16-bit word) 
; In: (DMA_Destination) = Destination address (16-bit word)
; Corrupts: HL, BC
DMA_Transfer:
	ld	hl, DMA_Setup 					; Load the start of the DMA control bytes in HL
	ld	b, DMA_SetupEnd - DMA_Setup		; Load the number of DMA control bytes in B
	ld	c, P8RW_DMA_DATAGEAR			; Load the DMA port number in C
	otir								; Output the DMA control bytes to the DMA port
	ret

DMA_Setup:
	db DMA_WR6_BASE_REGISTER_BYTE | DMA_WR6_BASE_RESET					; WR6: Reset
	db DMA_WR6_BASE_REGISTER_BYTE | DMA_WR6_BASE_RESET_PORT_A_TIMING	; WR6: Reset port A timing
    db DMA_WR6_BASE_REGISTER_BYTE | DMA_WR6_BASE_RESET_PORT_B_TIMING	; WR6: Reset port B timing

    db DMA_WR0_BASE_REGISTER_BYTE | DMA_WR0_BASE_TRANSFER | DMA_WR0_BASE_PORT_A_TO_PORT_B | DMA_WR0_BASE_PORT_A_START_ADDRESS_LOW_CHAIN | DMA_WR0_BASE_PORT_A_START_ADDRESS_HIGH_CHAIN | DMA_WR0_BASE_BLOCK_LENGTH_LOW_CHAIN | DMA_WR0_BASE_BLOCK_LENGTH_HIGH_CHAIN ; WR0: Transfer mode, A -> B
DMA_Source:
    dw $0000 ; WR0: Source address
DMA_Length:
    dw $0000 ; WR0: Length (Specified as number of bytes - 1, Minimum 2 bytes)

    db DMA_WR1_BASE_REGISTER_BYTE | DMA_WR1_BASE_PORT_A_IS_MEMORY | DMA_WR1_BASE_PORT_A_ADDRESS_INC | DMA_WR1_BASE_PORT_A_VARIABLE_TIMING_CHAIN ; WR1: Port A address incrementing, variable timing
    db DMA_WR1_PORT_A_VARIABLE_TIMING_BYTE | DMA_WR1_PORT_A_VARIABLE_TIMING_CYCLE_LENGTH_2 ; WR1: Cycle length port A
		  
    db DMA_WR2_BASE_REGISTER_BYTE | DMA_WR2_BASE_PORT_B_IS_MEMORY | DMA_WR2_BASE_PORT_B_ADDRESS_INC | DMA_WR2_BASE_PORT_B_VARIABLE_TIMING_CHAIN ; WR2: Port B address incrementing, variable timing
    db DMA_WR2_PORT_B_VARIABLE_TIMING_BYTE | DMA_WR2_PORT_B_VARIABLE_TIMING_CYCLE_LENGTH_2 ; WR2: Cycle length port B
  
    db DMA_WR3_BASE_REGISTER_BYTE | DMA_WR3_BASE_DMA_ENABLE ; WR3: DMA Enabled, Interrupt disabled

	db DMA_WR4_BASE_REGISTER_BYTE | DMA_WR4_BASE_PORT_B_START_ADDRESS_LOW_CHAIN | DMA_WR4_BASE_PORT_B_START_ADDRESS_HIGH_CHAIN | DMA_WR4_BASE_TYPE_CONTINUOUS ; WR4: Continuous mode
DMA_Destination:
    dw $0000 ; WR4: Destination address

	db DMA_WR5_BASE_REGISTER_BYTE | DMA_WR5_BASE_READY_ACTIVE_LOW | DMA_WR5_BASE_CE_WAIT_CE_ONLY | DMA_WR5_BASE_BLOCK_END_STOP ; WR5: Stop on end of block, RDY active LOW
	 
	db DMA_WR6_BASE_REGISTER_BYTE | DMA_WR6_BASE_LOAD 			; WR6: Load
	db DMA_WR6_BASE_REGISTER_BYTE | DMA_WR6_BASE_FORCE_READY	; WR6: Force Ready
	db DMA_WR6_BASE_REGISTER_BYTE | DMA_WR6_BASE_ENABLE_DMA		; WR6: Enable DMA
DMA_SetupEnd:
