; Palette routines
; EQU format
; V1.0
; Written by David Powell
; This file is released into the public domain


; Load a 256 colour palette in R3G3B3 format (512 bytes long)
; Note: Palette entries should be padded to 16 bits in RRRGGGBB 0000000B format
; In: A = Palette to set (NXRW_PALETTE_CONTROL value)
; In: HL = Start address of the palette data
; Corrupts: A, BC, D, HL
PL_Set9BitPalette:
	ld d, NXRW_PALETTE_CONTROL	; Select palette control register
	; A contains the NXRW_PALETTE_CONTROL value
	call NX_WriteRegister		; Update the register
	
	; Start at palette index 0
	ld d, NXRW_PALETTE_INDEX	; Select the palette index register
	xor a						; Set A to 0
	call NX_WriteRegister		; Update the register

	ld bc, 256					; Set the number of palette entries to 256
	ld (@palindex), bc			; Update the palette index counter
	
	; Load the palette values
	ld d, NXRW_PALETTE_VALUE_9BIT	; Select the 9-bit palette value register
	
@next3index:
	ld a, (hl)						; Load first byte in A
	call NX_WriteRegister			; Update the register
	
	inc hl							; Increment to the low byte of palette value
	
	ld a, (hl)						; Load the second byte in A (least significant blue bit)
	call NX_WriteRegister			; Update the register
	
	inc hl							; Increment to the high byte of the next palette value
	
	ld bc, (@palindex)				; Load the palette index into BC
	dec bc							; Decrement the palette index
	ld (@palindex), bc				; Store BC into the palette index
	ld a, b							; Load the high byte of the palette index into A
	or c							; Or the low byte of the palette index with the high byte
	jp nz, @next3index				; Jump if BC is not zero
	
	ret

; The current palette index loop counter
@palindex:
	dw 256
