; DMA Defines
; EQU format
; V1.0
; Written by David Powell
; This file is released into the public domain

DMA_RR0_TRANSFER_HAS_OCCURRED equ %00000001
DMA_RR0_NOT_READY_ACTIVE equ      %00000010
DMA_RR0_NOT_INTERRUPT_PENDING equ %00001000
DMA_RR0_NOT_MATCH_FOUND equ       %00010000
DMA_RR0_NOT_END_OF_BLOCK equ      %00100000

DMA_WR0_BASE_REGISTER_BYTE equ                   %00000000
DMA_WR0_BASE_TRANSFER_SEARCH_MASK equ            %00000011
DMA_WR0_BASE_TRANSFER equ                        %00000001
DMA_WR0_BASE_SEARCH equ                          %00000010
DMA_WR0_BASE_SEARCH_TRANSFER equ                 %00000011
DMA_WR0_BASE_PORT_B_TO_PORT_A equ                %00000000
DMA_WR0_BASE_PORT_A_TO_PORT_B equ                %00000100
DMA_WR0_BASE_PORT_A_START_ADDRESS_LOW_CHAIN equ  %00001000
DMA_WR0_BASE_PORT_A_START_ADDRESS_HIGH_CHAIN equ %00010000
DMA_WR0_BASE_BLOCK_LENGTH_LOW_CHAIN equ          %00100000
DMA_WR0_BASE_BLOCK_LENGTH_HIGH_CHAIN equ         %01000000

DMA_WR1_BASE_REGISTER_BYTE equ                %00000100
DMA_WR1_BASE_PORT_A_IS_MEMORY equ             %00000000
DMA_WR1_BASE_PORT_A_IS_IO equ                 %00001000
DMA_WR1_BASE_PORT_A_ADDRESS_MASK equ          %00110000
DMA_WR1_BASE_PORT_A_ADDRESS_DEC equ           %00000000
DMA_WR1_BASE_PORT_A_ADDRESS_INC equ           %00010000
DMA_WR1_BASE_PORT_A_ADDRESS_FIXED equ         %00100000
DMA_WR1_BASE_PORT_A_VARIABLE_TIMING_CHAIN equ %01000000

DMA_WR1_PORT_A_VARIABLE_TIMING_BYTE equ                %00000000
DMA_WR1_PORT_A_VARIABLE_TIMING_CYCLE_LENGTH_MASK equ   %00000011
DMA_WR1_PORT_A_VARIABLE_TIMING_CYCLE_LENGTH_4 equ      %00000000
DMA_WR1_PORT_A_VARIABLE_TIMING_CYCLE_LENGTH_3 equ      %00000001
DMA_WR1_PORT_A_VARIABLE_TIMING_CYCLE_LENGTH_2 equ      %00000010
DMA_WR1_PORT_A_VARIABLE_TIMING_NOT_IORQ_ENDS_EARLY equ %00000100
DMA_WR1_PORT_A_VARIABLE_TIMING_NOT_MREQ_ENDS_EARLY equ %00001000
DMA_WR1_PORT_A_VARIABLE_TIMING_NOT_RD_ENDS_EARLY equ   %01000000
DMA_WR1_PORT_A_VARIABLE_TIMING_NOT_WR_ENDS_EARLY equ   %10000000

DMA_WR2_BASE_REGISTER_BYTE equ                %00000000
DMA_WR2_BASE_PORT_B_IS_MEMORY equ             %00000000
DMA_WR2_BASE_PORT_B_IS_IO equ                 %00001000
DMA_WR2_BASE_PORT_B_ADDRESS_MASK equ          %00110000
DMA_WR2_BASE_PORT_B_ADDRESS_DEC equ           %00000000
DMA_WR2_BASE_PORT_B_ADDRESS_INC equ           %00010000
DMA_WR2_BASE_PORT_B_ADDRESS_FIXED equ         %00100000
DMA_WR2_BASE_PORT_B_VARIABLE_TIMING_CHAIN equ %01000000

DMA_WR2_PORT_B_VARIABLE_TIMING_BYTE equ                %00000000
DMA_WR2_PORT_B_VARIABLE_TIMING_CYCLE_LENGTH_MASK equ   %00000011
DMA_WR2_PORT_B_VARIABLE_TIMING_CYCLE_LENGTH_4 equ      %00000000
DMA_WR2_PORT_B_VARIABLE_TIMING_CYCLE_LENGTH_3 equ      %00000001
DMA_WR2_PORT_B_VARIABLE_TIMING_CYCLE_LENGTH_2 equ      %00000010
DMA_WR2_PORT_B_VARIABLE_TIMING_NOT_IORQ_ENDS_EARLY equ %00000100
DMA_WR2_PORT_B_VARIABLE_TIMING_NOT_MREQ_ENDS_EARLY equ %00001000
DMA_WR2_PORT_B_VARIABLE_TIMING_NOT_RD_ENDS_EARLY equ   %01000000
DMA_WR2_PORT_B_VARIABLE_TIMING_NOT_WR_ENDS_EARLY equ   %10000000

DMA_WR3_BASE_REGISTER_BYTE equ    %10000000
DMA_WR3_BASE_STOP_ON_MATCH equ    %00000100
DMA_WR3_BASE_MASK_BYTE_CHAIN equ  %00001000
DMA_WR3_BASE_MATCH_BYTE_CHAIN equ %00010000
DMA_WR3_BASE_INTERRUPT_ENABLE equ %00100000
DMA_WR3_BASE_DMA_ENABLE equ       %01000000

DMA_WR4_BASE_REGISTER_BYTE equ                   %10000001
DMA_WR4_BASE_PORT_B_START_ADDRESS_LOW_CHAIN equ  %00000100
DMA_WR4_BASE_PORT_B_START_ADDRESS_HIGH_CHAIN equ %00001000
DMA_WR4_BASE_INTERRUPT_CONTROL_CHAIN equ         %00010000
DMA_WR4_BASE_TYPE_MASK equ                       %01100000
DMA_WR4_BASE_TYPE_BYTE equ                       %00000000
DMA_WR4_BASE_TYPE_CONTINUOUS equ                 %00100000
DMA_WR4_BASE_TYPE_BURST equ                      %01000000
DMA_WR4_BASE_TYPE_DO_NOT_PROGRAM equ             %01100000

DMA_WR4_INTERRUPT_CONTROL_INTERRUPT_ON_MATCH equ        %00000001
DMA_WR4_INTERRUPT_CONTROL_INTERRUPT_AT_END_OF_BLOCK equ %00000010
DMA_WR4_INTERRUPT_CONTROL_PULSE_GENERATED equ           %00000100
DMA_WR4_INTERRUPT_CONTROL_PULSE_CONTROL_CHAIN equ       %00001000
DMA_WR4_INTERRUPT_CONTROL_INTERRUPT_VECTOR_CHAIN equ    %00010000
DMA_WR4_INTERRUPT_CONTROL_STATUS_AFFECTS_VECTOR equ     %00100000
DMA_WR4_INTERRUPT_CONTROL_INTERRUPT_ON_RDY equ          %01000000

DMA_WR4_INTERRUPT_VECTOR_INTERRUPT_ON_RDY equ                    %00000000
DMA_WR4_INTERRUPT_VECTOR_INTERRUPT_ON_MATCH equ                  %00000010
DMA_WR4_INTERRUPT_VECTOR_INTERRUPT_ON_END_OF_BLOCK equ           %00000100
DMA_WR4_INTERRUPT_VECTOR_INTERRUPT_ON_MATCH_AND_END_OF_BLOCK equ %00000110

DMA_WR5_BASE_REGISTER_BYTE equ          %10000010
DMA_WR5_BASE_READY_ACTIVE_LOW equ       %00000000
DMA_WR5_BASE_READY_ACTIVE_HIGH equ      %00001000
DMA_WR5_BASE_CE_WAIT_CE_ONLY equ        %00000000
DMA_WR5_BASE_CE_WAIT_MULTIPLEXED equ    %00010000
DMA_WR5_BASE_BLOCK_END_STOP equ         %00000000
DMA_WR5_BASE_BLOCK_END_AUTO_RESTART equ %00100000

DMA_WR6_BASE_REGISTER_BYTE equ                %10000011
DMA_WR6_BASE_RESET equ                        %01000000
DMA_WR6_BASE_RESET_PORT_A_TIMING equ          %01000100
DMA_WR6_BASE_RESET_PORT_B_TIMING equ          %01001000
DMA_WR6_BASE_LOAD equ                         %01001100
DMA_WR6_BASE_CONTINUE equ                     %01010000
DMA_WR6_BASE_DISABLE_INTERRUPTS equ           %00101100
DMA_WR6_BASE_ENABLE_INTERRUPTS equ            %00101000
DMA_WR6_BASE_RESET_AND_DISABLE_INTERRUPTS equ %00100000
DMA_WR6_BASE_ENABLE_AFTER_RETI equ            %00110100
DMA_WR6_BASE_READ_STATUS_BYTE equ             %00111100
DMA_WR6_BASE_REINITIALIZE_STATUS_BYTE equ     %00001000
DMA_WR6_BASE_INITIATE_READ_SEQUENCE equ       %00100100
DMA_WR6_BASE_FORCE_READY equ                  %00110000
DMA_WR6_BASE_ENABLE_DMA equ                   %00000100
DMA_WR6_BASE_DISABLE_DMA equ                  %00000000
DMA_WR6_BASE_READ_MASK_CHAIN equ              %00111000

DMA_WR6_READ_MASK_STATUS_BYTE equ         %00000001
DMA_WR6_READ_MASK_BYTE_COUNTER_LOW equ    %00000010
DMA_WR6_READ_MASK_BYTE_COUNTER_HIGH equ   %00000100
DMA_WR6_READ_MASK_PORT_A_ADDRESS_LOW equ  %00001000
DMA_WR6_READ_MASK_PORT_A_ADDRESS_HIGH equ %00010000
DMA_WR6_READ_MASK_PORT_B_ADDRESS_LOW equ  %00100000
DMA_WR6_READ_MASK_PORT_B_ADDRESS_HIGH equ %01000000
