; ESXDOS defines
; EQU format
; V1.0
; Written by David Powell
; This file is released into the public domain

; To use an ESXDOS call:
;
; Set parameter registers
; Issue a reset
;   rst ESXDOS_SYSCALL
; Then define the function 
;   defb ESXDOS_SYS_F_OPEN
; Then check the Carry Flag for the success flag
;   jp c, error
; Register A contains the error code, if there is an error

; Note: ESXDOS calls can only be made if ZX Spectrum Next Layer 2 is NOT paged in over the ROM!

; *** Code seperation ***

ESXDOS_BASE_HOOK equ 128
ESXDOS_BASE_MISC equ ESXDOS_BASE_HOOK + 8
ESXDOS_BASE_FSYS equ ESXDOS_BASE_MISC + 16

; *** ESXDOS entry points ***

; System call, single byte function number follows rst
ESXDOS_SYSCALL equ $08

; ZX ROM call, address follows rst
ESXDOS_ROMCALL equ $18

; Auxilliary for internal use
ESXDOS_AUXCALL equ $30

; *** NextOS only error hook for RST $18 and RST $10 inside a dot command ***

ESXDOS_NEXTOS_ROMCALL_DOT_ERROR_HOOK equ $95

; *** System Calls ***

; TODO: Documentation?
ESXDOS_SYS_DISK_STATUS equ ESXDOS_BASE_HOOK + 0

; Disk Read
; Read one block of data from a device
; Parameter registers:
;   A: Device letter
;   BCDE: Device position
;   IX: Destination memory address
; Return registers:
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_DISK_READ equ ESXDOS_BASE_HOOK + 1

; Disk Write
; Write one block of data from a device
; Parameter registers:
;   A: Device letter
;   BCDE: Device position
;   IX: Source memory address
; Return registers:
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_DISK_WRITE equ ESXDOS_BASE_HOOK + 2

; TODO: Documentation?
ESXDOS_SYS_DISK_IOCTL equ ESXDOS_BASE_HOOK + 3

; Disk Info
; Get a list of available devices or information about a specific device
; Parameter registers:
;   A: Device letter, 0 = Get list of available devices
;   IX: Destination buffer address
; Return registers:
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
; Buffer format (6 bytes):
;   Byte 1: Device Path; defined in ESDI_PATH_x
;   Byte 2: Device Flags; undocumented
;   Bytes 3-6: Device size in blocks
; Note: The buffer is over when you read a Device Path and you get a 0.
ESXDOS_SYS_DISK_INFO equ ESXDOS_BASE_HOOK + 4
ESDI_PATH_PARTITION_MASK equ          %00000111
ESDI_PATH_PARTITION_RAW equ           %00000000
ESDI_PATH_PARTITION_0 equ             %00000001
ESDI_PATH_PARTITION_1 equ             %00000010
ESDI_PATH_PARTITION_2 equ             %00000011
ESDI_PATH_PARTITION_3 equ             %00000100
ESDI_PATH_PARTITION_4 equ             %00000101
ESDI_PATH_PARTITION_5 equ             %00000110
ESDI_PATH_PARTITION_6 equ             %00000111
ESDI_PATH_TYPE_MASK equ               %00011000
ESDI_PATH_TYPE_RESERVED equ           %00000000
ESDI_PATH_TYPE_IDE equ                %00001000
ESDI_PATH_TYPE_FLOPPY equ             %00010000
ESDI_PATH_TYPE_VIRTUAL equ            %00011000
ESDI_PATH_ATTACH_MASK equ             %01100000
ESDI_PATH_ATTACH_PRIMARY_MASTER equ   %00000000
ESDI_PATH_ATTACH_SECONDARY_MASTER equ %00100000
ESDI_PATH_ATTACH_PRIMARY_SLAVE equ    %01000000
ESDI_PATH_ATTACH_SECONDARY_SLAVE equ  %01100000
ESDI_PATH_IDE_ATA equ                 %00000000
ESDI_PATH_IDE_ATAPI equ               %10000000

; TODO: Documentation
ESXDOS_SYS_M_DOSVERSION equ ESXDOS_BASE_MISC + 0

; Get Set Drive
; Get or set the default drive
; Parameter registers:
;   A: Default drive to set, 0 = Get default drive
; Return registers:
;   A: Current default drive, if requested
;   Carry Flag: 0 = success, 1 = error
;	  A: error code; if error
;
; Note: Programs that need to print all available drives (ie, file selector) just need to:
;   a) Process higher 5 bits to print the drive letter
;   b) Print the 'd'
;   c) Process the lower 3 bits to print the drive number
;   eg. %01000000 (64) would be drive "hd0"
ESXDOS_SYS_M_GETSETDRV equ ESXDOS_BASE_MISC + 1
ESMG_LOGICAL_NUMBER_MASK equ %00000111
ESMG_LOGICAL_NUMBER_0 equ    %00000000
ESMG_LOGICAL_NUMBER_1 equ    %00000001
ESMG_LOGICAL_NUMBER_2 equ    %00000010
ESMG_LOGICAL_NUMBER_3 equ    %00000011
ESMG_LOGICAL_NUMBER_4 equ    %00000100
ESMG_LOGICAL_NUMBER_5 equ    %00000101
ESMG_LOGICAL_NUMBER_6 equ    %00000110
ESMG_LOGICAL_NUMBER_7 equ    %00000111
ESMG_LOGICAL_LETTER_MASK equ %11111000
ESMG_LOGICAL_LETTER_A equ    %00001000
ESMG_LOGICAL_LETTER_B equ    %00010000
ESMG_LOGICAL_LETTER_C equ    %00011000
ESMG_LOGICAL_LETTER_D equ    %00100000
ESMG_LOGICAL_LETTER_E equ    %00101000
ESMG_LOGICAL_LETTER_F equ    %00110000
ESMG_LOGICAL_LETTER_G equ    %00111000
ESMG_LOGICAL_LETTER_H equ    %01000000
ESMG_LOGICAL_LETTER_I equ    %01001000
ESMG_LOGICAL_LETTER_J equ    %01010000
ESMG_LOGICAL_LETTER_K equ    %01011000
ESMG_LOGICAL_LETTER_L equ    %01100000
ESMG_LOGICAL_LETTER_M equ    %01101000
ESMG_LOGICAL_LETTER_N equ    %01110000
ESMG_LOGICAL_LETTER_O equ    %01111000
ESMG_LOGICAL_LETTER_P equ    %10000000
ESMG_LOGICAL_LETTER_Q equ    %10001000
ESMG_LOGICAL_LETTER_R equ    %10010000
ESMG_LOGICAL_LETTER_S equ    %10011000
ESMG_LOGICAL_LETTER_T equ    %10100000
ESMG_LOGICAL_LETTER_U equ    %10101000
ESMG_LOGICAL_LETTER_V equ    %10110000
ESMG_LOGICAL_LETTER_W equ    %10111000
ESMG_LOGICAL_LETTER_X equ    %11000000
ESMG_LOGICAL_LETTER_Y equ    %11001000
ESMG_LOGICAL_LETTER_Z equ    %11001000

; TODO: Documentation
ESXDOS_SYS_M_DRIVEINFO equ ESXDOS_BASE_MISC + 2

; TODO: Documentation
ESXDOS_SYS_M_TAPEIN equ ESXDOS_BASE_MISC + 3

; TODO: Documentation
ESXDOS_SYS_M_TAPEOUT equ ESXDOS_BASE_MISC + 4

; Get File Handle
; Get the file handle of a just loaded BASIC program
; Note: To be used with single-file loaders
; Parameter registers:
;   None
; Return registers:
;   A: File handle
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_M_GETHANDLE equ ESXDOS_BASE_MISC + 5

; Get Current Date / Time
; Get the current date/time in MSDOS format
; Parameter registers:
;   None
; Return registers:
;   BCDE: Current date and time
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
; Note: Date and time doesn't specify the 5th byte, so it's only 4 bytes, so only 2 seconds precision
;       DivIDE always reports a date and time of 23/04/1982 00:00:00
ESXDOS_SYS_M_GETDATE equ ESXDOS_BASE_MISC + 6

; TODO: Documentation
ESXDOS_SYS_F_MOUNT equ ESXDOS_BASE_FSYS + 0

; TODO: Documentation
ESXDOS_SYS_F_UMOUNT equ ESXDOS_BASE_FSYS + 1

; Open file
; Parameter registers:
;   A: Drive
;   IX: Address of null-terminated string containing path and/or filename
;   B: File open mode as ESXDOS_MODE_x bitfield
;   DE: Address of BASIC header data / buffer to be filled with BASIC header data
; Return registers:
;   A: File handle
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
; Note: The header is 8 bytes like +3DOS. Opening a headerless file will set the BASIC type to $FF.
;       The buffer at address DE is only used when file open mode has ESXDOS_MODE_USE_HEADER set.
;       There is one file pointer per file shared by reads and writes.
ESXDOS_SYS_F_OPEN equ ESXDOS_BASE_FSYS + 2
ESXDOS_MODE_READ equ          $01 ; Read access
ESXDOS_MODE_WRITE equ         $02 ; Write access
ESXDOS_MODE_OPEN_EXIST =      $00 ; Open if exists else error; fp equ 0
ESXDOS_MODE_CREAT_NOEXIST =   $04 ; If file exists error else create; fp equ 0
ESXDOS_MODE_OPEN_CREAT =      $08 ; Open if exists else create; fp equ 0
ESXDOS_MODE_CREAT_TRUNC =     $0C ; Create or replace an existing file; fp equ 0
ESXDOS_MODE_USE_HEADER equ    $40 ; Use +3DOS header passed in DE

; Close file
; Parameter registers:
;   A: File handle
; Return registers:
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_F_CLOSE equ ESXDOS_BASE_FSYS + 3

; File sync
; Syncs the file directory entry if the file has been written to
; (Will also flush the write cache in future)
; Parameter registers:
;   A: File handle
; Return registers:
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_F_SYNC equ ESXDOS_BASE_FSYS + 4

; Read file
; Parameter registers:
;   A: File handle
;   BC: Number of bytes to read
;   IX: Destination memory address
; Return registers:
;   BC: Number of bytes read
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_F_READ equ ESXDOS_BASE_FSYS + 5

; Write file
; Parameter registers:
;   A: File handle
;   BC: Number of bytes to write
;   IX: Source memory address
; Return registers:
;   BC: Number of bytes written
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_F_WRITE equ ESXDOS_BASE_FSYS + 6

; Seek within file
; Parameter registers:
;   A: File handle
;   BCDE: Seek length
;   IX: Seek mode; ESXDOS_SEEK_SET = Forward from start of the file
;                  ESXDOS_SEEK_FWD = Forward from current position
;                  ESXDOS_SEEK_BWD = Backward from current position
; Return registers:
;   BCDE: Current file position
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_F_SEEK equ ESXDOS_BASE_FSYS + 7

; Get file position
; Parameter registers:
;   A: File handle
; Return registers:
;   BCDE: Current file position
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_F_FGETPOS equ ESXDOS_BASE_FSYS + 8

; Get file status
; Parameter registers:
;   A: File handle
;   IX: Data buffer memory address
; Return registers:
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
; Buffer format (11 bytes):
;   Byte 1: Drive
;   Byte 2: Device
;   Byte 3: File attributes
;   Byte 4-7: Date
;   Byte 8-11: File size
ESXDOS_SYS_F_FSTAT equ ESXDOS_BASE_FSYS + 9

; TODO: Documentation
ESXDOS_SYS_F_FTRUNCATE equ ESXDOS_BASE_FSYS + 10

; Open directory
; Parameter registers:
;   A: Drive
;   B: Access mode (Only ESXDOS_MODE_USE_HEADER flag is used)
;   IX: Address of null-terminated string containing path
; Return registers:
;   A : Directory handle
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_F_OPENDIR equ ESXDOS_BASE_FSYS + 11

; Read a directory entry
; Parameter registers:
;   A: Directory handle
;   IX: Data buffer memory address
; Return registers:
;   A:  !0 = More entries available, 0 = End of entries
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
; Buffer format:
; <asciiz> file/dirname
; <byte>   attributes (like MSDOS)
; <dword>  date
; <dword>  filesize
;
; If opened with BASIC header bit, after the normal entry
; follows the BASIC header (with type=$ff if headerless)
ESXDOS_SYS_F_READDIR equ ESXDOS_BASE_FSYS + 12

; TODO: Documentation
ESXDOS_SYS_F_TELLDIR equ ESXDOS_BASE_FSYS + 13

; TODO: Documentation
ESXDOS_SYS_F_SEEKDIR equ ESXDOS_BASE_FSYS + 14

; TODO: Documentation
ESXDOS_SYS_F_REWINDDIR equ ESXDOS_BASE_FSYS + 15

; Get current directory path
; Parameter registers:
;   A: Drive
;   IX: Buffer memory address
; Return registers:
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_F_GETCWD equ ESXDOS_BASE_FSYS + 16

; Change current directory
; Parameter registers:
;   A: Drive
;   IX: Address of null-terminated string containing path
; Return registers:
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_F_CHDIR equ ESXDOS_BASE_FSYS + 17

; TODO: Documentation
ESXDOS_SYS_F_MKDIR equ ESXDOS_BASE_FSYS + 18

; TODO: Documentation
ESXDOS_SYS_F_RMDIR equ ESXDOS_BASE_FSYS + 19

; TODO: Documentation
ESXDOS_SYS_F_STAT equ ESXDOS_BASE_FSYS + 20

; Delete file
; Parameter registers:
;   A: Drive
;   IX: Address of null-terminated string containing path and/or filename
; Return registers:
;   Carry Flag: 0 = success, 1 = error
;     A: error code; if error
ESXDOS_SYS_F_UNLINK equ ESXDOS_BASE_FSYS + 21

; TODO: Documentation
ESXDOS_SYS_F_TRUNCATE equ ESXDOS_BASE_FSYS + 22

; TODO: Documentation
ESXDOS_SYS_F_CHMOD equ ESXDOS_BASE_FSYS + 23

; TODO: Documentation
ESXDOS_SYS_F_RENAME equ ESXDOS_BASE_FSYS + 24

; TODO: Documentation
ESXDOS_SYS_F_GETFREE equ ESXDOS_BASE_FSYS + 25

; *** Limits ***

; Max pathname length in bytes including terminating \0
;ESXDOS_PATH_MAX equ 128

; Max pathname length in bytes including terminating \0 (nextos)
ESXDOS_PATH_MAX equ 256

; Max filename length in bytes not including terminating \0
ESXDOS_NAME_MAX equ 12

; *** File Attribute (like MSDOS) ***
; these are taken from MSDOS

ESXDOS_ATTR_READ_ONLY equ    $01 ; File is read-only
ESXDOS_ATTR_HIDDEN equ       $02 ; File should be hidden in some listings
ESXDOS_ATTR_SYSTEM equ       $04 ; Ill-defined
ESXDOS_ATTR_VOLUME_LABEL equ $08 ; File stores volume label
ESXDOS_ATTR_DIRECTORY equ    $10 ; File is a directory
ESXDOS_ATTR_ARCHIVE equ      $20 ; File has been modified so should be backed up

; *** Shortcut drive identifiers ***

ESXDOS_DRIVE_CURRENT equ $2A ; '*'
ESXDOS_DRIVE_SYSTEM equ  $24 ; '$'

; *** Seek type ***

ESXDOS_SEEK_SET equ 0 ; Forward from the beginning of the file
ESXDOS_SEEK_FWD equ 1 ; Forward from the current position
ESXDOS_SEEK_BWD equ 2 ; Backward from the current position

; *** Error codes ***

ESXDOS_OK equ             0 ; 0 OK 0:1
ESXDOS_EOK equ            1 ; O.K. ESXDOS, 0:1
ESXDOS_ENONSENSE equ      2 ; Nonsense in ESXDOS, 0:1
ESXDOS_ESTEND equ         3 ; Statement END error, 0:1
ESXDOS_EWRTYPE equ        4 ; Wrong file TYPE, 0:1
ESXDOS_ENOENT equ         5 ; No such FILE or DIR, 0:1
ESXDOS_EIO equ            6 ; I/O ERROR, 0:1
ESXDOS_EINVAL equ         7 ; Invalid FILENAME, 0:1
ESXDOS_EACCES equ         8 ; Access DENIED, 0:1
ESXDOS_ENOSP equ          9 ; Drive FULL, 0:1
ESXDOS_ENXIO equ         10 ; Invalid I/O REQUEST, 0:1
ESXDOS_ENODRV equ        11 ; No such DRIVE, 0:1
ESXDOS_ENFILE equ        12 ; Too many OPEN FILES, 0:1
ESXDOS_EBADF equ         13 ; Bad file DESCRIPTOR, 0:1
ESXDOS_ENODEV equ        14 ; No such DEVICE, 0:1
ESXDOS_EOVERFLOW equ     15 ; File pointer OVERFLOW, 0:1
ESXDOS_EISDIR equ        16 ; Is a DIRECTORY, 0:1
ESXDOS_ENOTDIR equ       17 ; Not a DIRECTORY, 0:1
ESXDOS_EEXIST equ        18 ; File already EXISTS, 0:1
ESXDOS_EPATH equ         19 ; Invalid PATH, 0:1
ESXDOS_ENOSYS equ        20 ; No SYS, 0:1
ESXDOS_ENAMETOOLONG equ  21 ; Path too LONG, 0:1
ESXDOS_ENOCMD equ        22 ; No such COMMAND, 0:1
ESXDOS_EINUSE equ        23 ; File in USE, 0:1
ESXDOS_ERDONLY equ       24 ; File is READ ONLY, 0:1

; These were not documented but were found in emulation

ESXDOS_EVERIFY equ       25 ; Verify FAILED, 0:1
ESXDOS_ELOADINGKO equ    26 ; Loading .KO FAILED, 0:1
ESXDOS_EDIRINUSE equ     27 ; Directory NOT EMPTY, 0:1
ESXDOS_EMAPRAMACTIVE equ 28 ; MAPRAM is ACTIVE, 0:1
ESXDOS_EDRIVEBUSY equ    29 ; Drive is BUSY, 0:1
ESXDOS_EFSUNKNOWN equ    30 ; Unknown FILESYSTEM, 0:1
ESXDOS_EDEVICEBUSY equ   31 ; Device is BUSY, 0:1

ESXDOS_EMAXCODE equ      31 ; Largest valid error codes



