; ZX Spectrum Next Layer 2 Routines
; EQU format
; V1.0
; Written by David Powell
; This file is released into the public domain


; Copy 6 consecutive 8K SRAM memory banks to the current Layer 2 screen
; Switches memory at $E000 between 8K SRAM banks, restores original bank on success 
; In: A = Starting SRAM bank
; Out: Carry Set = Error
; Corrupts: A, BC, DE
L2_Copy:
	; Store the parameters
	ld (@CurrentBank), a			; Store the supplied starting SRAM bank number
	ld a, 3							; Load A with 3 as the layer 2 ROM overlay is split into 3 banks
	ld (@LoopCounter), a			; Store 3 into the loop counter

	; Remember the original SRAM bank currently at $E000
	ld a, NXRW_MEMORY_SLOT_7		; Select the memory slot 7 register
	call NX_ReadRegister			; Read the register
	ld (@OriginalBank), a			; Store the original SRAM bank
	
	; Set the the Layer 2 Access value
	ld e, L2A_WRITE_PAGING | L2A_VISIBLE | L2A_BANK_0	; Enable write paging, make layer 2 visible and swap in bank 0
	
	; Set up source and length for DMA transfers
	ld bc, M_NX_MEMORY_SLOT_7		; Get the address of memory slot 7 ($E000)
	ld (DMA_Source), bc				; Set the DMA source to memory slot 7
	ld bc, M_NX_MEMORY_SLOT_SIZE	; Get the memory slot size ($2000, 8K)
	ld (DMA_Length), bc				; Set the DMA length to 8K

@nextbank:
	; Change Layer 2 bank
	ld bc, P16W_NX_LAYER2_ACCESS	; Select the layer 2 access port
	out (c), e						; Output the current access value
	
	ld a, e							; move E, the Layer 2 access value into A
	add a, $40						; Increase the Layer 2 Access bank number
	ld e, a							; Store A back into E, the Layer 2 access value

	; Change to the next SRAM bank at $E000
	ld d, NXRW_MEMORY_SLOT_7		; Select the memory slot 7 register ($E000)
	ld a, (@CurrentBank)			; Get the current SRAM bank number
	call NX_WriteRegister			; Set the register
	
	; Copy top half
	ld bc, M_NX_LAYER2_ACCESS_START	; Get the address of the top 8K of the layer 2 current bank
	ld (DMA_Destination), bc		; Set the DMA destination address to the top 8K of the current layer 2 bank
	call DMA_Transfer				; Start the DMA transfer
	
	; Increment current bank
	ld a, (@CurrentBank)			; Get the current SRAM bank number
	inc a							; Increment the SRAM bank number
	ld (@CurrentBank), a			; Store the SRAM bank number
	
	; Change to the next SRAM bank at $E000
	ld d, NXRW_MEMORY_SLOT_7		; Select the memory slot 7 register ($E000)
	ld a, (@CurrentBank)			; Get the current SRAM bank number
	call NX_WriteRegister			; Set the register
	
	; copy bottom half
	ld bc, M_NX_LAYER2_ACCESS_START + M_NX_MEMORY_SLOT_SIZE ; Get the address of the bottom 8K of the layer 2 current bank
	ld (DMA_Destination), bc		; Set the DMA destination to the bottom 8K of the current layer 2 bank
	call DMA_Transfer				; Start the DMA transfer
	
	; Increment current bank
	ld a, (@CurrentBank)			; Get the current SRAM bank number
	inc a							; Increment the SRAM bank number
	ld (@CurrentBank), a			; Store the SRAM bank number
	
	ld a, (@LoopCounter)			; Get the current loop counter
	dec a							; Decrement the counter
	ld (@LoopCounter), a			; Store the new loop counter
	
	jp nz, @nextbank				; There are more banks so loop again
	
	; Restore original SRAM bank at $E000
	ld d, NXRW_MEMORY_SLOT_7		; Select the memory slot 7 register ($E000)
	ld a, (@OriginalBank)			; Get the original SRAM bank number
	call NX_WriteRegister			; Set the register
	
	xor a							; Set result to 0 and clears carry flag
	ret

; The current loop counter
@LoopCounter:
	db 0

; The current SRAM bank number
@CurrentBank:
	db 0
	
; The original SRAM bank paged into memory slot 7
@OriginalBank:
	db 0
