; ZX Spectrum Next routines
; EQU format
; V1.0
; Written by David Powell
; This file is released into the public domain


; Write to a Next register
; In: D = The register number to write to
; In: A = The register value
; Corrupts: BC
NX_WriteRegister:
	ld bc, P16W_NX_NEXT_REGISTER_SELECT
	out (c), d
	
	ld bc, P16RW_NX_NEXT_REGISTER_VALUE
	out (c), a
	
	ret

; Read a Next register
; In: A = The register number to read
; Out: A = The register value
; Corrupts: BC
NX_ReadRegister:
	ld bc, P16W_NX_NEXT_REGISTER_SELECT
	out (c), a
	
	ld bc, P16RW_NX_NEXT_REGISTER_VALUE
	in a, (c)
	
	ret
