; Wibble effect for the ZX Spectrum NEXT
; EQU format
; V1.0
; Written by David Powell
; This file is released into the public domain

opt sna=main:stack_start
opt Z80
opt ZXNEXT

; Include the symbolic names
include "include/zxdefines.inc"
include "include/nextdefines.inc"
include "include/esxdosdefines.inc"
include "include/dmadefines.inc"

; Starting banks for loaded files
BANK_OVERLAY equ 29
BANK_PALETTE equ 30
BANK_IMAGE equ   31

; Set the code start address
org 33000

; start
main:
	di						; Disable interrupts
	
	ld sp, stack_start		; Set the stack pointer
	
	; Set the speed to 7MHz
	ld d, NXRW_TURBO_MODE	; Select turbo mode register
	ld a, TM_SPEED_7MHZ		; Set the speed to 7MHz
	call NX_WriteRegister	; Update the register
	
	; Set the border to black
	ld a, ULA_BORDER_BLACK	; Load the border colour into A 
	out (P8RW_ULA), a		; Update the ULA with the border colour
	
	; Load the ROM overlay code containing the interrupt mode 1 handler
	ld ix, overlay			; Address of NULL terminated file name
	ld bc, 0				; Read start position High Word
	ld de, 0				; Read start position Low Word
	ld hl, 8 * 1024			; Number of bytes to load
	ld a, BANK_OVERLAY		; Starting SRAM bank number
	call SD_LoadIntoBanks	; Load the file
	jp c, error				; If carry set, jump to error handler
	
	; Load the palette
	ld ix, palette			; Address of NULL terminated file name
	ld bc, 0				; Read start position High Word
	ld de, 0				; Read start position Low Word
	ld hl, 512				; Number of bytes to load
	ld a, BANK_PALETTE		; Starting SRAM bank number
	call SD_LoadIntoBanks	; Load the file
	jp c, error				; If carry set, jump to the error handler
	
	; Load the image
	ld ix, image			; Address of NULL terminated file name
	ld bc, 0				; Read start position High Word
	ld de, 0				; Read start position Low Word
	ld hl, 48 * 1024		; Number of bytes to load
	ld a, BANK_IMAGE		; Starting SRAM bank number
	call SD_LoadIntoBanks	; Load the file
	jp c, error				; If carry set, jump to error handler
		
	; Switch slot 7 ($E000) to the palette
	ld d, NXRW_MEMORY_SLOT_7	; Select memory slot 7 register
	ld a, BANK_PALETTE			; Select the bank containing the palette
	call NX_WriteRegister		; Update the register
	
	; Set the layer 2 1st palette
	ld a, PC_PALETTE_MODIFY_LAYER2_1ST 	; Select the layer 2 1st palette
	ld hl, M_NX_MEMORY_SLOT_7			; Load HL with the start address of memory slot 7
	call PL_Set9BitPalette				; Update the palette
	
	; Set the global transparency colour
	ld d, NXRW_GLOBAL_TRANSPARENCY	; Select the global transparency register
	ld a, %00000000					; Select pure black (which doesn't exist in the palette)
	call NX_WriteRegister			; Update the register
	
	; Copy the image to the layer 2 screen
	ld a, BANK_IMAGE				; Select the image bank number
	call L2_Copy					; DMA copy the image bank contents to the layer 2 screen
		
	; Switch slot 0 ($0000) to the overlay
	ld d, NXRW_MEMORY_SLOT_0		; Select memory slot 0 register
	ld a, BANK_OVERLAY				; Select the ROM overlay bank
	call NX_WriteRegister			; Update the register
	
	; Set the interrupt LSB to 0
	ld d, NXRW_LINE_INTERRUPT_VALUE_LSB	; Select the line interrupt least significant byte
	ld a, 0								; Select line 0
	call NX_WriteRegister				; Update the register
	
	; Disable the ULA interrupt and enable the Next Line interrupt
	ld d, NXRW_LINE_INTERRUPT_CONTROL								; Select the line interrupt control register
	ld a, LIC_DISABLE_ULA_INTERRUPT | LIC_ENABLE_LINE_INTERRUPT		; Disable the standard ULA interrupt and enable the Next line interrupt
	call NX_WriteRegister											; Update the register
	
	; Enable Interrupt Mode 1
	im 1					; Select interrupt mode 1
	ei						; Enable interrupts

	; Do nothing while waiting for the interrupt
repeat:
	halt					; Halt until an interrupt
	jp repeat				; Repeat the loop
	
; Error routine
error:
	ld a, ULA_BORDER_RED	; Select the red border colour
	out (P8RW_ULA), a		; Update the ULA with the border colour
	di						; Disable interrupts
error_loop:
	halt					; Halt the processor
	jp error_loop			; Loop forever

; ROM overlay code filename	
overlay:
	db "overlay.bin", 0
	
; Palette filename
palette:
	db "palette.pal", 0
	
; Image filename
image:
	db "image.raw", 0
	
; 256 bytes of stack
stack_end:
	ds 255
stack_start: db 0

; Include the library routines
include "library/sdcardlib.asm"
include "library/dmalib.asm"
include "library/layer2lib.asm"
include "library/nextlib.asm"
include "library/palettelib.asm"
